/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.startree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.startree.CompositePredicateEvaluator;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.startree.AggregationFunctionColumnPair;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2Metadata;

public class StarTreeUtils {
    public static final String USE_STAR_TREE_KEY = "useStarTree";

    private StarTreeUtils() {
    }

    public static boolean isStarTreeDisabled(QueryContext queryContext) {
        Map<String, String> debugOptions = queryContext.getDebugOptions();
        return debugOptions != null && "false".equalsIgnoreCase(debugOptions.get(USE_STAR_TREE_KEY));
    }

    @Nullable
    public static AggregationFunctionColumnPair[] extractAggregationFunctionPairs(AggregationFunction[] aggregationFunctions) {
        int numAggregationFunctions = aggregationFunctions.length;
        AggregationFunctionColumnPair[] aggregationFunctionColumnPairs = new AggregationFunctionColumnPair[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            AggregationFunctionColumnPair aggregationFunctionColumnPair = AggregationFunctionUtils.getAggregationFunctionColumnPair(aggregationFunctions[i]);
            if (aggregationFunctionColumnPair == null) {
                return null;
            }
            aggregationFunctionColumnPairs[i] = aggregationFunctionColumnPair;
        }
        return aggregationFunctionColumnPairs;
    }

    @Nullable
    public static Map<String, List<CompositePredicateEvaluator>> extractPredicateEvaluatorsMap(IndexSegment indexSegment, @Nullable FilterContext filter, Map<Predicate, PredicateEvaluator> predicateEvaluatorMap) {
        FilterContext filterNode;
        if (filter == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<CompositePredicateEvaluator>> predicateEvaluatorsMap = new HashMap<String, List<CompositePredicateEvaluator>>();
        LinkedList<FilterContext> queue = new LinkedList<FilterContext>();
        queue.add(filter);
        block5: while ((filterNode = (FilterContext)queue.poll()) != null) {
            switch (filterNode.getType()) {
                case AND: {
                    queue.addAll(filterNode.getChildren());
                    continue block5;
                }
                case OR: {
                    Pair<String, List<PredicateEvaluator>> pair = StarTreeUtils.isOrClauseValidForStarTree(indexSegment, filterNode, predicateEvaluatorMap);
                    if (pair == null) {
                        return null;
                    }
                    List predicateEvaluators = (List)pair.getRight();
                    if (predicateEvaluators.isEmpty()) continue block5;
                    predicateEvaluatorsMap.computeIfAbsent((String)pair.getLeft(), k -> new ArrayList()).add(new CompositePredicateEvaluator(predicateEvaluators));
                    continue block5;
                }
                case PREDICATE: {
                    Predicate predicate = filterNode.getPredicate();
                    PredicateEvaluator predicateEvaluator = StarTreeUtils.getPredicateEvaluator(indexSegment, predicate, predicateEvaluatorMap);
                    if (predicateEvaluator == null) {
                        return null;
                    }
                    if (predicateEvaluator.isAlwaysTrue()) continue block5;
                    predicateEvaluatorsMap.computeIfAbsent(predicate.getLhs().getIdentifier(), k -> new ArrayList()).add(new CompositePredicateEvaluator(Collections.singletonList(predicateEvaluator)));
                    continue block5;
                }
            }
            throw new IllegalStateException();
        }
        return predicateEvaluatorsMap;
    }

    public static boolean isFitForStarTree(StarTreeV2Metadata starTreeV2Metadata, AggregationFunctionColumnPair[] aggregationFunctionColumnPairs, @Nullable ExpressionContext[] groupByExpressions, Set<String> predicateColumns) {
        for (AggregationFunctionColumnPair aggregationFunctionColumnPair : aggregationFunctionColumnPairs) {
            if (starTreeV2Metadata.containsFunctionColumnPair(aggregationFunctionColumnPair)) continue;
            return false;
        }
        HashSet starTreeDimensions = new HashSet(starTreeV2Metadata.getDimensionsSplitOrder());
        if (groupByExpressions != null) {
            HashSet groupByColumns = new HashSet();
            for (ExpressionContext groupByExpression : groupByExpressions) {
                groupByExpression.getColumns(groupByColumns);
            }
            if (!starTreeDimensions.containsAll(groupByColumns)) {
                return false;
            }
        }
        return starTreeDimensions.containsAll(predicateColumns);
    }

    @Nullable
    private static Pair<String, List<PredicateEvaluator>> isOrClauseValidForStarTree(IndexSegment indexSegment, FilterContext filter, Map<Predicate, PredicateEvaluator> predicateEvaluatorMap) {
        assert (filter.getType() == FilterContext.Type.OR);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        StarTreeUtils.extractOrClausePredicates(filter, predicates);
        String identifier = null;
        ArrayList<PredicateEvaluator> predicateEvaluators = new ArrayList<PredicateEvaluator>();
        for (Predicate predicate : predicates) {
            PredicateEvaluator predicateEvaluator = StarTreeUtils.getPredicateEvaluator(indexSegment, predicate, predicateEvaluatorMap);
            if (predicateEvaluator == null) {
                return null;
            }
            if (predicateEvaluator.isAlwaysTrue()) {
                return Pair.of(null, Collections.emptyList());
            }
            if (predicateEvaluator.isAlwaysFalse()) continue;
            String predicateIdentifier = predicate.getLhs().getIdentifier();
            if (identifier == null) {
                identifier = predicateIdentifier;
            } else if (!identifier.equals(predicateIdentifier)) {
                return null;
            }
            predicateEvaluators.add(predicateEvaluator);
        }
        return Pair.of(identifier, predicateEvaluators);
    }

    private static boolean extractOrClausePredicates(FilterContext filter, List<Predicate> predicates) {
        assert (filter.getType() == FilterContext.Type.OR);
        block5: for (FilterContext child : filter.getChildren()) {
            switch (child.getType()) {
                case AND: {
                    return false;
                }
                case OR: {
                    if (!StarTreeUtils.extractOrClausePredicates(child, predicates)) {
                        return false;
                    }
                    predicates.add(child.getPredicate());
                    continue block5;
                }
                case PREDICATE: {
                    predicates.add(child.getPredicate());
                    continue block5;
                }
            }
            throw new IllegalStateException();
        }
        return true;
    }

    @Nullable
    private static PredicateEvaluator getPredicateEvaluator(IndexSegment indexSegment, Predicate predicate, Map<Predicate, PredicateEvaluator> predicateEvaluatorMap) {
        ExpressionContext lhs = predicate.getLhs();
        if (lhs.getType() != ExpressionContext.Type.IDENTIFIER) {
            return null;
        }
        String column = lhs.getIdentifier();
        DataSource dataSource = indexSegment.getDataSource(column);
        Dictionary dictionary = dataSource.getDictionary();
        if (dictionary == null) {
            return null;
        }
        switch (predicate.getType()) {
            case REGEXP_LIKE: 
            case TEXT_MATCH: 
            case IS_NULL: 
            case IS_NOT_NULL: {
                return null;
            }
        }
        return predicateEvaluatorMap.get(predicate);
    }
}

