/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.startree.plan;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.core.operator.ProjectionOperator;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.startree.CompositePredicateEvaluator;
import org.apache.pinot.core.startree.plan.StarTreeDocIdSetPlanNode;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2;

public class StarTreeProjectionPlanNode
implements PlanNode {
    private final Map<String, DataSource> _dataSourceMap = new HashMap<String, DataSource>();
    private final StarTreeDocIdSetPlanNode _starTreeDocIdSetPlanNode;

    public StarTreeProjectionPlanNode(StarTreeV2 starTreeV2, Set<String> projectionColumns, Map<String, List<CompositePredicateEvaluator>> predicateEvaluatorsMap, @Nullable Set<String> groupByColumns, @Nullable Map<String, String> debugOptions) {
        for (String projectionColumn : projectionColumns) {
            this._dataSourceMap.put(projectionColumn, starTreeV2.getDataSource(projectionColumn));
        }
        this._starTreeDocIdSetPlanNode = new StarTreeDocIdSetPlanNode(starTreeV2, predicateEvaluatorsMap, groupByColumns, debugOptions);
    }

    public ProjectionOperator run() {
        return new ProjectionOperator(this._dataSourceMap, this._starTreeDocIdSetPlanNode.run());
    }
}

