/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.startree.plan;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.startree.CompositePredicateEvaluator;
import org.apache.pinot.core.startree.plan.StarTreeProjectionPlanNode;
import org.apache.pinot.segment.spi.index.startree.AggregationFunctionColumnPair;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2;

public class StarTreeTransformPlanNode
implements PlanNode {
    private final List<ExpressionContext> _groupByExpressions;
    private final StarTreeProjectionPlanNode _starTreeProjectionPlanNode;

    public StarTreeTransformPlanNode(StarTreeV2 starTreeV2, AggregationFunctionColumnPair[] aggregationFunctionColumnPairs, @Nullable ExpressionContext[] groupByExpressions, Map<String, List<CompositePredicateEvaluator>> predicateEvaluatorsMap, @Nullable Map<String, String> debugOptions) {
        HashSet<String> groupByColumns;
        HashSet<String> projectionColumns = new HashSet<String>();
        for (AggregationFunctionColumnPair aggregationFunctionColumnPair : aggregationFunctionColumnPairs) {
            projectionColumns.add(aggregationFunctionColumnPair.toColumnName());
        }
        if (groupByExpressions != null) {
            this._groupByExpressions = Arrays.asList(groupByExpressions);
            groupByColumns = new HashSet<String>();
            for (ExpressionContext groupByExpression : groupByExpressions) {
                groupByExpression.getColumns(groupByColumns);
            }
            projectionColumns.addAll(groupByColumns);
        } else {
            this._groupByExpressions = Collections.emptyList();
            groupByColumns = null;
        }
        this._starTreeProjectionPlanNode = new StarTreeProjectionPlanNode(starTreeV2, projectionColumns, predicateEvaluatorsMap, groupByColumns, debugOptions);
    }

    public TransformOperator run() {
        return new TransformOperator(this._starTreeProjectionPlanNode.run(), this._groupByExpressions);
    }
}

