/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.transport;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.transport.QueryRouter;
import org.apache.pinot.core.transport.ServerResponse;
import org.apache.pinot.core.transport.ServerRoutingInstance;

@ThreadSafe
public class AsyncQueryResponse {
    private final QueryRouter _queryRouter;
    private final long _requestId;
    private final ConcurrentHashMap<ServerRoutingInstance, ServerResponse> _responseMap;
    private final CountDownLatch _countDownLatch;
    private final long _maxEndTimeMs;
    private volatile Exception _brokerRequestSendException;

    public AsyncQueryResponse(QueryRouter queryRouter, long requestId, Set<ServerRoutingInstance> serversQueried, long startTimeMs, long timeoutMs) {
        this._queryRouter = queryRouter;
        this._requestId = requestId;
        int numServersQueried = serversQueried.size();
        this._responseMap = new ConcurrentHashMap(numServersQueried);
        for (ServerRoutingInstance serverRoutingInstance : serversQueried) {
            this._responseMap.put(serverRoutingInstance, new ServerResponse(startTimeMs));
        }
        this._countDownLatch = new CountDownLatch(numServersQueried);
        this._maxEndTimeMs = startTimeMs + timeoutMs;
    }

    public Map<ServerRoutingInstance, ServerResponse> getResponse() throws InterruptedException {
        try {
            this._countDownLatch.await(this._maxEndTimeMs - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            ConcurrentHashMap<ServerRoutingInstance, ServerResponse> concurrentHashMap = this._responseMap;
            return concurrentHashMap;
        }
        finally {
            this._queryRouter.markQueryDone(this._requestId);
        }
    }

    public String getStats() {
        StringBuilder stringBuilder = new StringBuilder("(Server=SubmitDelayMs,ResponseDelayMs,ResponseSize,DeserializationTimeMs,RequestSentDelayMs)");
        for (Map.Entry<ServerRoutingInstance, ServerResponse> entry : this._responseMap.entrySet()) {
            stringBuilder.append(';').append(entry.getKey().getShortName()).append('=').append(entry.getValue().toString());
        }
        return stringBuilder.toString();
    }

    void markRequestSubmitted(ServerRoutingInstance serverRoutingInstance) {
        this._responseMap.get(serverRoutingInstance).markRequestSubmitted();
    }

    void markRequestSent(ServerRoutingInstance serverRoutingInstance, long requestSentLatencyMs) {
        this._responseMap.get(serverRoutingInstance).markRequestSent(requestSentLatencyMs);
    }

    void receiveDataTable(ServerRoutingInstance serverRoutingInstance, DataTable dataTable, int responseSize, int deserializationTimeMs) {
        this._responseMap.get(serverRoutingInstance).receiveDataTable(dataTable, responseSize, deserializationTimeMs);
        this._countDownLatch.countDown();
    }

    void markQueryFailed() {
        int count = (int)this._countDownLatch.getCount();
        for (int i = 0; i < count; ++i) {
            this._countDownLatch.countDown();
        }
    }

    void markServerDown(ServerRoutingInstance serverRoutingInstance) {
        ServerResponse serverResponse = this._responseMap.get(serverRoutingInstance);
        if (serverResponse != null && serverResponse.getDataTable() == null) {
            this.markQueryFailed();
        }
    }

    public Exception getBrokerRequestSendException() {
        return this._brokerRequestSendException;
    }

    void setBrokerRequestSendException(Exception brokerRequestSendException) {
        this._brokerRequestSendException = brokerRequestSendException;
    }
}

