/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.transport;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.BrokerMeter;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.common.datatable.DataTableFactory;
import org.apache.pinot.core.transport.QueryRouter;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTableHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataTableHandler.class);
    private final QueryRouter _queryRouter;
    private final ServerRoutingInstance _serverRoutingInstance;
    private final BrokerMetrics _brokerMetrics;

    public DataTableHandler(QueryRouter queryRouter, ServerRoutingInstance serverRoutingInstance, BrokerMetrics brokerMetrics) {
        this._queryRouter = queryRouter;
        this._serverRoutingInstance = serverRoutingInstance;
        this._brokerMetrics = brokerMetrics;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        LOGGER.info("Channel for server: {} is now active", (Object)this._serverRoutingInstance);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        LOGGER.error("Channel for server: {} is now inactive, marking server down", (Object)this._serverRoutingInstance);
        this._queryRouter.markServerDown(this._serverRoutingInstance);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
        int responseSize = msg.readableBytes();
        this._brokerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)BrokerMeter.NETTY_CONNECTION_BYTES_RECEIVED, (long)responseSize);
        try {
            long deserializationStartTimeMs = System.currentTimeMillis();
            DataTable dataTable = DataTableFactory.getDataTable(msg.nioBuffer());
            this._queryRouter.receiveDataTable(this._serverRoutingInstance, dataTable, responseSize, (int)(System.currentTimeMillis() - deserializationStartTimeMs));
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while deserializing data table of size: {} from server: {}", new Object[]{responseSize, this._serverRoutingInstance, e});
            this._brokerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)BrokerMeter.DATA_TABLE_DESERIALIZATION_EXCEPTIONS, 1L);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOGGER.error("Caught exception while handling response from server: {}", (Object)this._serverRoutingInstance, (Object)cause);
        this._brokerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)BrokerMeter.RESPONSE_FETCH_EXCEPTIONS, 1L);
    }
}

