/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.transport;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import org.apache.pinot.common.config.TlsConfig;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.utils.TlsUtils;
import org.apache.pinot.core.query.scheduler.QueryScheduler;
import org.apache.pinot.core.transport.InstanceRequestHandler;
import org.apache.pinot.server.access.AccessControl;
import org.apache.pinot.server.access.AllowAllAccessFactory;

public class QueryServer {
    private final int _port;
    private final QueryScheduler _queryScheduler;
    private final ServerMetrics _serverMetrics;
    private final TlsConfig _tlsConfig;
    private final AccessControl _accessControl;
    private EventLoopGroup _bossGroup;
    private EventLoopGroup _workerGroup;
    private Channel _channel;

    public QueryServer(int port, QueryScheduler queryScheduler, ServerMetrics serverMetrics) {
        this(port, queryScheduler, serverMetrics, null, new AllowAllAccessFactory().create());
    }

    public QueryServer(int port, QueryScheduler queryScheduler, ServerMetrics serverMetrics, TlsConfig tlsConfig, AccessControl accessControl) {
        this._port = port;
        this._queryScheduler = queryScheduler;
        this._serverMetrics = serverMetrics;
        this._tlsConfig = tlsConfig;
        this._accessControl = accessControl;
    }

    public void start() {
        this._bossGroup = new NioEventLoopGroup();
        this._workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            this._channel = ((ServerBootstrap)((ServerBootstrap)serverBootstrap.group(this._bossGroup, this._workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    if (QueryServer.this._tlsConfig != null) {
                        QueryServer.this.attachSSLHandler(ch);
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4), new LengthFieldPrepender(4), new InstanceRequestHandler(QueryServer.this._queryScheduler, QueryServer.this._serverMetrics, QueryServer.this._accessControl)});
                }
            }).bind(this._port).sync().channel();
        }
        catch (Exception e) {
            this._workerGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            this._bossGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            throw new RuntimeException(e);
        }
    }

    private void attachSSLHandler(SocketChannel ch) {
        try {
            if (this._tlsConfig.getKeyStorePath() == null) {
                throw new IllegalArgumentException("Must provide key store path for secured server");
            }
            SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((KeyManagerFactory)TlsUtils.createKeyManagerFactory((TlsConfig)this._tlsConfig)).sslProvider(SslProvider.valueOf((String)this._tlsConfig.getSslProvider()));
            if (this._tlsConfig.getTrustStorePath() != null) {
                sslContextBuilder.trustManager(TlsUtils.createTrustManagerFactory((TlsConfig)this._tlsConfig));
            }
            if (this._tlsConfig.isClientAuthEnabled()) {
                sslContextBuilder.clientAuth(ClientAuth.REQUIRE);
            }
            ch.pipeline().addLast("ssl", (ChannelHandler)sslContextBuilder.build().newHandler(ch.alloc()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void shutDown() {
        try {
            this._channel.close().sync();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this._workerGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            this._bossGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        }
    }
}

