/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.transport;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.config.TlsConfig;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.BrokerGauge;
import org.apache.pinot.common.metrics.BrokerMeter;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.metrics.BrokerTimer;
import org.apache.pinot.common.request.InstanceRequest;
import org.apache.pinot.common.utils.TlsUtils;
import org.apache.pinot.core.transport.AsyncQueryResponse;
import org.apache.pinot.core.transport.DataTableHandler;
import org.apache.pinot.core.transport.QueryRouter;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.thrift.TBase;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransportException;

@ThreadSafe
public class ServerChannels {
    public static final String CHANNEL_LOCK_TIMEOUT_MSG = "Timeout while acquiring channel lock";
    private final QueryRouter _queryRouter;
    private final BrokerMetrics _brokerMetrics;
    private final ThreadLocal<TSerializer> _threadLocalTSerializer;
    private final ConcurrentHashMap<ServerRoutingInstance, ServerChannel> _serverToChannelMap = new ConcurrentHashMap();
    private final EventLoopGroup _eventLoopGroup = new NioEventLoopGroup();
    private final TlsConfig _tlsConfig;

    public ServerChannels(QueryRouter queryRouter, BrokerMetrics brokerMetrics) {
        this(queryRouter, brokerMetrics, null);
    }

    public ServerChannels(QueryRouter queryRouter, BrokerMetrics brokerMetrics, TlsConfig tlsConfig) {
        this._queryRouter = queryRouter;
        this._brokerMetrics = brokerMetrics;
        this._tlsConfig = tlsConfig;
        this._threadLocalTSerializer = ThreadLocal.withInitial(() -> {
            try {
                return new TSerializer((TProtocolFactory)new TCompactProtocol.Factory());
            }
            catch (TTransportException e) {
                throw new RuntimeException("Failed to initialize Thrift Serializer", e);
            }
        });
    }

    public void sendRequest(String rawTableName, AsyncQueryResponse asyncQueryResponse, ServerRoutingInstance serverRoutingInstance, InstanceRequest instanceRequest, long timeoutMs) throws Exception {
        byte[] requestBytes = this._threadLocalTSerializer.get().serialize((TBase)instanceRequest);
        this._serverToChannelMap.computeIfAbsent(serverRoutingInstance, x$0 -> new ServerChannel((ServerRoutingInstance)x$0)).sendRequest(rawTableName, asyncQueryResponse, serverRoutingInstance, requestBytes, timeoutMs);
    }

    public void shutDown() {
        this._eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
    }

    @ThreadSafe
    private class ServerChannel {
        final ServerRoutingInstance _serverRoutingInstance;
        final Bootstrap _bootstrap;
        final ReentrantLock _channelLock = new ReentrantLock();
        Channel _channel;

        ServerChannel(ServerRoutingInstance serverRoutingInstance) {
            this._serverRoutingInstance = serverRoutingInstance;
            this._bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().remoteAddress(serverRoutingInstance.getHostname(), serverRoutingInstance.getPort()).group(ServerChannels.this._eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    if (ServerChannels.this._tlsConfig != null) {
                        ServerChannel.this.attachSSLHandler(ch);
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4), new LengthFieldPrepender(4), new DataTableHandler(ServerChannels.this._queryRouter, ServerChannel.this._serverRoutingInstance, ServerChannels.this._brokerMetrics)});
                }
            });
        }

        private void attachSSLHandler(SocketChannel ch) {
            try {
                SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(SslProvider.valueOf((String)ServerChannels.this._tlsConfig.getSslProvider()));
                if (ServerChannels.this._tlsConfig.getKeyStorePath() != null) {
                    sslContextBuilder.keyManager(TlsUtils.createKeyManagerFactory((TlsConfig)ServerChannels.this._tlsConfig));
                }
                if (ServerChannels.this._tlsConfig.getTrustStorePath() != null) {
                    sslContextBuilder.trustManager(TlsUtils.createTrustManagerFactory((TlsConfig)ServerChannels.this._tlsConfig));
                }
                ch.pipeline().addLast("ssl", (ChannelHandler)sslContextBuilder.build().newHandler(ch.alloc()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendRequest(String rawTableName, AsyncQueryResponse asyncQueryResponse, ServerRoutingInstance serverRoutingInstance, byte[] requestBytes, long timeoutMs) throws Exception {
            if (this._channelLock.tryLock(timeoutMs, TimeUnit.MILLISECONDS)) {
                try {
                    this.sendRequest(rawTableName, asyncQueryResponse, serverRoutingInstance, requestBytes);
                }
                finally {
                    this._channelLock.unlock();
                }
            } else {
                throw new TimeoutException(ServerChannels.CHANNEL_LOCK_TIMEOUT_MSG);
            }
        }

        private void sendRequest(String rawTableName, AsyncQueryResponse asyncQueryResponse, ServerRoutingInstance serverRoutingInstance, byte[] requestBytes) throws Exception {
            if (this._channel == null || !this._channel.isActive()) {
                long startTime = System.currentTimeMillis();
                this._channel = this._bootstrap.connect().sync().channel();
                ServerChannels.this._brokerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)BrokerGauge.NETTY_CONNECTION_CONNECT_TIME_MS, System.currentTimeMillis() - startTime);
            }
            long sendRequestStartTimeMs = System.currentTimeMillis();
            this._channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])requestBytes)).addListener(f -> {
                long requestSentLatencyMs = System.currentTimeMillis() - sendRequestStartTimeMs;
                ServerChannels.this._brokerMetrics.addTimedTableValue(rawTableName, (AbstractMetrics.Timer)BrokerTimer.NETTY_CONNECTION_SEND_REQUEST_LATENCY, requestSentLatencyMs, TimeUnit.MILLISECONDS);
                asyncQueryResponse.markRequestSent(serverRoutingInstance, requestSentLatencyMs);
            });
            ServerChannels.this._brokerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)BrokerMeter.NETTY_CONNECTION_REQUESTS_SENT, 1L);
            ServerChannels.this._brokerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)BrokerMeter.NETTY_CONNECTION_BYTES_SENT, (long)requestBytes.length);
        }
    }
}

