/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.transport;

import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang.StringUtils;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.utils.CommonConstants;

public class ServerInstance {
    private static final char HOSTNAME_PORT_DELIMITER = '_';
    private final String _hostname;
    private final int _port;
    private final int _grpcPort;
    private final int _tlsPort;

    public ServerInstance(InstanceConfig instanceConfig) {
        String hostname = instanceConfig.getHostName();
        if (hostname != null) {
            this._hostname = hostname.startsWith("Server_") ? hostname.substring(CommonConstants.Helix.SERVER_INSTANCE_PREFIX_LENGTH) : hostname;
            this._port = Integer.parseInt(instanceConfig.getPort());
        } else {
            String instanceName = instanceConfig.getInstanceName();
            if (instanceName.startsWith("Server_")) {
                instanceName = instanceName.substring(CommonConstants.Helix.SERVER_INSTANCE_PREFIX_LENGTH);
            }
            String[] hostnameAndPort = StringUtils.split((String)instanceName, (char)'_');
            this._hostname = hostnameAndPort[0];
            this._port = Integer.parseInt(hostnameAndPort[1]);
        }
        int tlsPort = -1;
        int grpcPort = -1;
        if (instanceConfig.getRecord() != null) {
            tlsPort = instanceConfig.getRecord().getIntField("nettyTlsPort", -1);
            grpcPort = instanceConfig.getRecord().getIntField("grpcPort", -1);
        }
        this._tlsPort = tlsPort;
        this._grpcPort = grpcPort;
    }

    @VisibleForTesting
    ServerInstance(String hostname, int port) {
        this._hostname = hostname;
        this._port = port;
        this._grpcPort = -1;
        this._tlsPort = -1;
    }

    public String getHostname() {
        return this._hostname;
    }

    public int getPort() {
        return this._port;
    }

    public int getGrpcPort() {
        return this._grpcPort;
    }

    public ServerRoutingInstance toServerRoutingInstance(TableType tableType) {
        return new ServerRoutingInstance(this._hostname, this._port, tableType);
    }

    @Deprecated
    public ServerRoutingInstance toServerRoutingInstance(TableType tableType, boolean preferTls) {
        if (!preferTls) {
            return this.toServerRoutingInstance(tableType);
        }
        if (this._tlsPort <= 0) {
            return this.toServerRoutingInstance(tableType);
        }
        return new ServerRoutingInstance(this._hostname, this._tlsPort, tableType, true);
    }

    public ServerRoutingInstance toServerRoutingInstance(TableType tableType, Type type) {
        switch (type) {
            case GRPC: {
                if (this._grpcPort > 0) {
                    return new ServerRoutingInstance(this._hostname, this._grpcPort, tableType, false);
                }
                return new ServerRoutingInstance(this._hostname, this._port, tableType);
            }
            case TTS: {
                if (this._tlsPort > 0) {
                    return new ServerRoutingInstance(this._hostname, this._tlsPort, tableType, true);
                }
                return new ServerRoutingInstance(this._hostname, this._port, tableType);
            }
        }
        return new ServerRoutingInstance(this._hostname, this._port, tableType);
    }

    public int hashCode() {
        return 31 * this._hostname.hashCode() + this._port;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ServerInstance) {
            ServerInstance that = (ServerInstance)obj;
            return this._hostname.equals(that._hostname) && this._port == that._port;
        }
        return false;
    }

    public String toString() {
        return "Server_" + this._hostname + '_' + this._port;
    }

    public static enum Type {
        DEFAULT,
        GRPC,
        TTS;

    }
}

