/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.transport;

import com.google.common.net.InternetDomainName;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.spi.config.table.TableType;

@ThreadSafe
public class ServerRoutingInstance {
    private static final String SHORT_OFFLINE_SUFFIX = "_O";
    private static final String SHORT_REALTIME_SUFFIX = "_R";
    private static final Map<String, String> SHORT_HOSTNAME_MAP = new ConcurrentHashMap<String, String>();
    private final boolean _tlsEnabled;
    private final String _hostname;
    private final int _port;
    private final TableType _tableType;

    public ServerRoutingInstance(String hostname, int port, TableType tableType) {
        this(hostname, port, tableType, false);
    }

    public ServerRoutingInstance(String hostname, int port, TableType tableType, boolean tlsEnabled) {
        this._hostname = hostname;
        this._port = port;
        this._tableType = tableType;
        this._tlsEnabled = tlsEnabled;
    }

    public String getHostname() {
        return this._hostname;
    }

    public int getPort() {
        return this._port;
    }

    public TableType getTableType() {
        return this._tableType;
    }

    public String getShortName() {
        String shortHostname = SHORT_HOSTNAME_MAP.computeIfAbsent(this._hostname, hostname -> {
            try {
                InternetDomainName domainName = InternetDomainName.from((String)hostname);
                return (String)domainName.parts().get(0);
            }
            catch (Exception e) {
                return hostname;
            }
        });
        return shortHostname + (this._tableType == TableType.OFFLINE ? SHORT_OFFLINE_SUFFIX : SHORT_REALTIME_SUFFIX);
    }

    public boolean isTlsEnabled() {
        return this._tlsEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerRoutingInstance that = (ServerRoutingInstance)o;
        return this._tlsEnabled == that._tlsEnabled && this._port == that._port && this._hostname.equals(that._hostname) && this._tableType == that._tableType;
    }

    public int hashCode() {
        return Objects.hash(this._tlsEnabled, this._hostname, this._port, this._tableType);
    }

    public String toString() {
        return this.getShortName();
    }
}

