/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.util;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.query.request.context.QueryContext;

public class GapfillUtils {
    private static final String POST_AGGREGATE_GAP_FILL = "postaggregategapfill";
    private static final String FILL = "fill";

    private GapfillUtils() {
    }

    public static ExpressionContext stripGapfill(ExpressionContext expression) {
        if (expression.getType() != ExpressionContext.Type.FUNCTION) {
            return expression;
        }
        FunctionContext function = expression.getFunction();
        String functionName = GapfillUtils.canonicalizeFunctionName(function.getFunctionName());
        if (functionName.equals(POST_AGGREGATE_GAP_FILL) || functionName.equals(FILL)) {
            return (ExpressionContext)function.getArguments().get(0);
        }
        return expression;
    }

    public static boolean isPostAggregateGapfill(ExpressionContext expressionContext) {
        if (expressionContext.getType() != ExpressionContext.Type.FUNCTION) {
            return false;
        }
        return POST_AGGREGATE_GAP_FILL.equals(GapfillUtils.canonicalizeFunctionName(expressionContext.getFunction().getFunctionName()));
    }

    public static boolean isPostAggregateGapfill(QueryContext queryContext) {
        for (ExpressionContext expressionContext : queryContext.getSelectExpressions()) {
            if (!GapfillUtils.isPostAggregateGapfill(expressionContext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFill(ExpressionContext expressionContext) {
        if (expressionContext.getType() != ExpressionContext.Type.FUNCTION) {
            return false;
        }
        return FILL.equals(GapfillUtils.canonicalizeFunctionName(expressionContext.getFunction().getFunctionName()));
    }

    public static Serializable getDefaultValue(DataSchema.ColumnDataType dataType) {
        switch (dataType) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case TIMESTAMP: {
                return dataType.convertAndFormat((Object)0);
            }
            case STRING: 
            case JSON: 
            case BYTES: {
                return "";
            }
            case INT_ARRAY: {
                return new int[0];
            }
            case LONG_ARRAY: {
                return new long[0];
            }
            case FLOAT_ARRAY: {
                return new float[0];
            }
            case DOUBLE_ARRAY: {
                return new double[0];
            }
            case STRING_ARRAY: 
            case TIMESTAMP_ARRAY: {
                return new String[0];
            }
            case BOOLEAN_ARRAY: {
                return new boolean[0];
            }
            case BYTES_ARRAY: {
                return new byte[0][0];
            }
        }
        throw new IllegalStateException(String.format("Cannot provide the default value for the type: %s", dataType));
    }

    private static String canonicalizeFunctionName(String functionName) {
        return StringUtils.remove((String)functionName, (char)'_').toLowerCase();
    }

    public static enum FillType {
        FILL_DEFAULT_VALUE,
        FILL_PREVIOUS_VALUE;

    }
}

