/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.config.TlsConfig;
import org.apache.pinot.common.utils.TlsUtils;
import org.apache.pinot.core.transport.ListenerConfig;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.internal.guava.ThreadFactoryBuilder;
import org.glassfish.jersey.process.JerseyProcessingUncaughtExceptionHandler;
import org.glassfish.jersey.server.ResourceConfig;

public final class ListenerConfigUtil {
    private static final String DEFAULT_HOST = "0.0.0.0";
    private static final String DOT_ACCESS_PROTOCOLS = ".access.protocols";
    public static final Set<String> SUPPORTED_PROTOCOLS = new HashSet<String>(Arrays.asList("http", "https"));

    private ListenerConfigUtil() {
    }

    public static List<ListenerConfig> buildListenerConfigs(PinotConfiguration config, String namespace, TlsConfig tlsDefaults) {
        if (StringUtils.isBlank((CharSequence)config.getProperty(namespace + DOT_ACCESS_PROTOCOLS))) {
            return new ArrayList<ListenerConfig>();
        }
        String[] protocols = config.getProperty(namespace + DOT_ACCESS_PROTOCOLS).split(",");
        return Arrays.stream(protocols).map(protocol -> ListenerConfigUtil.buildListenerConfig(config, namespace, protocol, tlsDefaults)).collect(Collectors.toList());
    }

    public static List<ListenerConfig> buildControllerConfigs(PinotConfiguration controllerConf) {
        ArrayList<ListenerConfig> listeners = new ArrayList<ListenerConfig>();
        String portString = controllerConf.getProperty("controller.port");
        if (portString != null) {
            listeners.add(new ListenerConfig("http", DEFAULT_HOST, Integer.parseInt(portString), "http", new TlsConfig()));
        }
        TlsConfig tlsDefaults = TlsUtils.extractTlsConfig((PinotConfiguration)controllerConf, (String)"controller.tls");
        listeners.addAll(ListenerConfigUtil.buildListenerConfigs(controllerConf, "controller", tlsDefaults));
        return listeners;
    }

    public static List<ListenerConfig> buildBrokerConfigs(PinotConfiguration brokerConf) {
        ArrayList<ListenerConfig> listeners = new ArrayList<ListenerConfig>();
        String queryPortString = brokerConf.getProperty("pinot.broker.client.queryPort");
        if (queryPortString != null) {
            listeners.add(new ListenerConfig("http", DEFAULT_HOST, Integer.parseInt(queryPortString), "http", new TlsConfig()));
        }
        TlsConfig tlsDefaults = TlsUtils.extractTlsConfig((PinotConfiguration)brokerConf, (String)"pinot.broker.tls");
        listeners.addAll(ListenerConfigUtil.buildListenerConfigs(brokerConf, "pinot.broker.client", tlsDefaults));
        if (listeners.isEmpty()) {
            listeners.add(new ListenerConfig("http", DEFAULT_HOST, 8099, "http", new TlsConfig()));
        }
        return listeners;
    }

    public static List<ListenerConfig> buildServerAdminConfigs(PinotConfiguration serverConf) {
        ArrayList<ListenerConfig> listeners = new ArrayList<ListenerConfig>();
        String adminApiPortString = serverConf.getProperty("pinot.server.adminapi.port");
        if (adminApiPortString != null) {
            listeners.add(new ListenerConfig("http", DEFAULT_HOST, Integer.parseInt(adminApiPortString), "http", new TlsConfig()));
        }
        TlsConfig tlsDefaults = TlsUtils.extractTlsConfig((PinotConfiguration)serverConf, (String)"pinot.server.tls");
        listeners.addAll(ListenerConfigUtil.buildListenerConfigs(serverConf, "pinot.server.adminapi", tlsDefaults));
        if (listeners.isEmpty()) {
            listeners.add(new ListenerConfig("http", DEFAULT_HOST, 8097, "http", new TlsConfig()));
        }
        return listeners;
    }

    public static List<ListenerConfig> buildMinionAdminConfigs(PinotConfiguration minionConf) {
        ArrayList<ListenerConfig> listeners = new ArrayList<ListenerConfig>();
        String adminApiPortString = minionConf.getProperty("pinot.minion.adminapi.port");
        if (adminApiPortString != null) {
            listeners.add(new ListenerConfig("http", DEFAULT_HOST, Integer.parseInt(adminApiPortString), "http", new TlsConfig()));
        }
        TlsConfig tlsDefaults = TlsUtils.extractTlsConfig((PinotConfiguration)minionConf, (String)"pinot.minion.tls");
        listeners.addAll(ListenerConfigUtil.buildListenerConfigs(minionConf, "pinot.minion.adminapi", tlsDefaults));
        if (listeners.isEmpty()) {
            listeners.add(new ListenerConfig("http", DEFAULT_HOST, 6500, "http", new TlsConfig()));
        }
        return listeners;
    }

    private static ListenerConfig buildListenerConfig(PinotConfiguration config, String namespace, String name, TlsConfig tlsConfig) {
        String protocolNamespace = namespace + DOT_ACCESS_PROTOCOLS + "." + name;
        return new ListenerConfig(name, ListenerConfigUtil.getHost(config.getProperty(protocolNamespace + ".host", DEFAULT_HOST)), ListenerConfigUtil.getPort(config.getProperty(protocolNamespace + ".port")), ListenerConfigUtil.getProtocol(config.getProperty(protocolNamespace + ".protocol"), name), TlsUtils.extractTlsConfig((PinotConfiguration)config, (String)(protocolNamespace + ".tls"), (TlsConfig)tlsConfig));
    }

    private static String getHost(String configuredHost) {
        return Optional.ofNullable(configuredHost).map(String::trim).filter(host -> !host.isEmpty()).orElseThrow(() -> new IllegalArgumentException(configuredHost + " is not a valid host"));
    }

    private static int getPort(String configuredPort) {
        return Optional.ofNullable(configuredPort).map(String::trim).filter(port -> !port.isEmpty()).map(Integer::valueOf).orElseThrow(() -> new IllegalArgumentException(configuredPort + " is not a valid port"));
    }

    private static String getProtocol(String configuredProtocol, String listenerName) {
        Optional<String> optProtocol = Optional.ofNullable(configuredProtocol).map(String::trim).filter(protocol -> !protocol.isEmpty());
        if (!optProtocol.isPresent()) {
            return Optional.of(listenerName).filter(SUPPORTED_PROTOCOLS::contains).orElseThrow(() -> new IllegalArgumentException("No protocol set for listener" + listenerName + " and '" + listenerName + "' is not a valid protocol either"));
        }
        return optProtocol.filter(SUPPORTED_PROTOCOLS::contains).orElseThrow(() -> new IllegalArgumentException(configuredProtocol + " is not a valid protocol"));
    }

    public static HttpServer buildHttpServer(ResourceConfig resConfig, List<ListenerConfig> listenerConfigs) {
        Preconditions.checkNotNull(listenerConfigs);
        HttpServer httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)URI.create("http://0.0.0.0/"), (ResourceConfig)resConfig, (boolean)false);
        httpServer.removeListener("grizzly");
        listenerConfigs.forEach(listenerConfig -> ListenerConfigUtil.configureListener(httpServer, listenerConfig));
        return httpServer;
    }

    public static void configureListener(HttpServer httpServer, ListenerConfig listenerConfig) {
        NetworkListener listener = new NetworkListener(listenerConfig.getName() + "-" + listenerConfig.getPort(), listenerConfig.getHost(), listenerConfig.getPort());
        listener.getTransport().getWorkerThreadPoolConfig().setThreadFactory(new ThreadFactoryBuilder().setNameFormat("grizzly-http-server-%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new JerseyProcessingUncaughtExceptionHandler()).build());
        if ("https".equals(listenerConfig.getProtocol())) {
            listener.setSecure(true);
            listener.setSSLEngineConfig(ListenerConfigUtil.buildSSLEngineConfigurator(listenerConfig.getTlsConfig()));
        }
        httpServer.addListener(listener);
    }

    private static SSLEngineConfigurator buildSSLEngineConfigurator(TlsConfig tlsConfig) {
        SSLContextConfigurator sslContextConfigurator = new SSLContextConfigurator();
        if (tlsConfig.getKeyStorePath() != null) {
            Preconditions.checkNotNull((Object)tlsConfig.getKeyStorePassword(), (Object)"key store password required");
            sslContextConfigurator.setKeyStoreFile(ListenerConfigUtil.cacheInTempFile(tlsConfig.getKeyStorePath()).getAbsolutePath());
            sslContextConfigurator.setKeyStorePass(tlsConfig.getKeyStorePassword());
        }
        if (tlsConfig.getTrustStorePath() != null) {
            Preconditions.checkNotNull((Object)tlsConfig.getKeyStorePassword(), (Object)"trust store password required");
            sslContextConfigurator.setTrustStoreFile(ListenerConfigUtil.cacheInTempFile(tlsConfig.getTrustStorePath()).getAbsolutePath());
            sslContextConfigurator.setTrustStorePass(tlsConfig.getTrustStorePassword());
        }
        return new SSLEngineConfigurator(sslContextConfigurator).setClientMode(false).setNeedClientAuth(tlsConfig.isClientAuthEnabled()).setEnabledProtocols(new String[]{"TLSv1.2"});
    }

    public static String toString(Collection<? extends ListenerConfig> listenerConfigs) {
        return StringUtils.join((Object[])listenerConfigs.stream().map(listener -> String.format("%s://%s:%d", listener.getProtocol(), listener.getHost(), listener.getPort())).toArray(), (String)", ");
    }

    private static File cacheInTempFile(String sourceUrl) {
        try {
            URL url = TlsUtils.makeKeyStoreUrl((String)sourceUrl);
            if ("file".equals(url.getProtocol())) {
                return new File(url.getPath());
            }
            File tempFile = Files.createTempFile("pinot-keystore-", null, new FileAttribute[0]).toFile();
            tempFile.deleteOnExit();
            try (InputStream is = url.openStream();
                 FileOutputStream os = new FileOutputStream(tempFile);){
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            return tempFile;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Could not retrieve and cache keystore from '%s'", sourceUrl), e);
        }
    }
}

