/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.ListUtils;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixManager;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.common.utils.helix.HelixHelper;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.apache.pinot.spi.utils.retry.RetryPolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerServerSegmentFinder {
    private static final Logger _logger = LoggerFactory.getLogger(PeerServerSegmentFinder.class);
    private static final int MAX_NUM_ATTEMPTS = 5;
    private static final int INITIAL_DELAY_MS = 500;
    private static final double DELAY_SCALE_FACTOR = 2.0;

    private PeerServerSegmentFinder() {
    }

    public static List<URI> getPeerServerURIs(String segmentName, String downloadScheme, HelixManager helixManager) {
        LLCSegmentName llcSegmentName = new LLCSegmentName(segmentName);
        String tableNameWithType = TableNameBuilder.forType((TableType)TableType.REALTIME).tableNameWithType(llcSegmentName.getTableName());
        HelixAdmin helixAdmin = helixManager.getClusterManagmentTool();
        String clusterName = helixManager.getClusterName();
        if (clusterName == null) {
            _logger.error("ClusterName not found");
            return ListUtils.EMPTY_LIST;
        }
        ArrayList<URI> onlineServerURIs = new ArrayList<URI>();
        try {
            RetryPolicies.exponentialBackoffRetryPolicy((int)5, (long)500L, (double)2.0).attempt(() -> {
                PeerServerSegmentFinder.getOnlineServersFromExternalView(segmentName, downloadScheme, tableNameWithType, helixAdmin, clusterName, onlineServerURIs);
                return !onlineServerURIs.isEmpty();
            });
        }
        catch (Exception e) {
            _logger.error("Failure in getting online servers for segment {}", (Object)segmentName, (Object)e);
        }
        return onlineServerURIs;
    }

    private static void getOnlineServersFromExternalView(String segmentName, String downloadScheme, String tableNameWithType, HelixAdmin helixAdmin, String clusterName, List<URI> onlineServerURIs) {
        ExternalView externalViewForResource = HelixHelper.getExternalViewForResource((HelixAdmin)helixAdmin, (String)clusterName, (String)tableNameWithType);
        if (externalViewForResource == null) {
            _logger.warn("External View not found for table {}", (Object)tableNameWithType);
            return;
        }
        Map instanceToStateMap = externalViewForResource.getStateMap(segmentName);
        for (Map.Entry instanceState : instanceToStateMap.entrySet()) {
            if (!"ONLINE".equals(instanceState.getValue())) continue;
            String instanceId = (String)instanceState.getKey();
            _logger.info("Found ONLINE server {} for segment {}.", (Object)instanceId, (Object)segmentName);
            InstanceConfig instanceConfig = helixAdmin.getInstanceConfig(clusterName, instanceId);
            String hostName = instanceConfig.getHostName();
            int port = PeerServerSegmentFinder.getServerAdminPort(helixAdmin, clusterName, instanceId);
            try {
                onlineServerURIs.add(new URI(StringUtil.join((String)"/", (String[])new String[]{downloadScheme + "://" + hostName + ":" + port, "segments", tableNameWithType, segmentName})));
            }
            catch (URISyntaxException e) {
                _logger.warn("Error in uri syntax: ", (Throwable)e);
            }
        }
    }

    private static int getServerAdminPort(HelixAdmin helixAdmin, String clusterName, String instanceId) {
        try {
            return Integer.parseInt((String)HelixHelper.getInstanceConfigsMapFor((String)instanceId, (String)clusterName, (HelixAdmin)helixAdmin).get("adminPort"));
        }
        catch (Exception e) {
            _logger.warn("Failed to retrieve ADMIN PORT for instanceId {} in the cluster {} ", new Object[]{instanceId, clusterName, e});
            return 8098;
        }
    }
}

