/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.util;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;

public class QueryOptionsUtils {
    private QueryOptionsUtils() {
    }

    @Nullable
    public static Long getTimeoutMs(Map<String, String> queryOptions) {
        String timeoutMsString = queryOptions.get("timeoutMs");
        if (timeoutMsString != null) {
            long timeoutMs = Long.parseLong(timeoutMsString);
            Preconditions.checkState((timeoutMs > 0L ? 1 : 0) != 0, (String)"Query timeout must be positive, got: %s", (long)timeoutMs);
            return timeoutMs;
        }
        return null;
    }

    public static boolean isGroupByModeSQL(Map<String, String> queryOptions) {
        return "sql".equalsIgnoreCase(queryOptions.get("groupByMode"));
    }

    public static boolean isResponseFormatSQL(Map<String, String> queryOptions) {
        return "sql".equalsIgnoreCase(queryOptions.get("responseFormat"));
    }

    public static boolean isPreserveType(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("preserveType"));
    }

    public static boolean isSkipUpsert(Map<String, String> queryOptions) {
        return Boolean.parseBoolean(queryOptions.get("skipUpsert"));
    }

    @Nullable
    public static Integer getMaxExecutionThreads(Map<String, String> queryOptions) {
        String maxExecutionThreadsString = queryOptions.get("maxExecutionThreads");
        return maxExecutionThreadsString != null ? Integer.valueOf(Integer.parseInt(maxExecutionThreadsString)) : null;
    }

    @Nullable
    public static Integer getMinSegmentGroupTrimSize(Map<String, String> queryOptions) {
        String minSegmentGroupTrimSizeString = queryOptions.get("minSegmentGroupTrimSize");
        return minSegmentGroupTrimSizeString != null ? Integer.valueOf(Integer.parseInt(minSegmentGroupTrimSizeString)) : null;
    }

    @Nullable
    public static Integer getMinServerGroupTrimSize(Map<String, String> queryOptions) {
        String minServerGroupTrimSizeString = queryOptions.get("minServerGroupTrimSize");
        return minServerGroupTrimSizeString != null ? Integer.valueOf(Integer.parseInt(minServerGroupTrimSizeString)) : null;
    }
}

