/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.realtime;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.MasterSlaveSMD;
import org.apache.pinot.common.utils.helix.LeadControllerUtils;
import org.apache.pinot.pql.parsers.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerLeaderLocator {
    private static ControllerLeaderLocator _instance = null;
    public static final Logger LOGGER = LoggerFactory.getLogger(ControllerLeaderLocator.class);
    private static final long MIN_INVALIDATE_INTERVAL_MS = 30000L;
    private final HelixManager _helixManager;
    private final Map<Integer, Pair<String, Integer>> _cachedControllerLeaderMap;
    private volatile boolean _cachedControllerLeaderValid = false;
    private volatile long _lastCacheInvalidationTimeMs = 0L;

    ControllerLeaderLocator(HelixManager helixManager) {
        this._helixManager = helixManager;
        this._cachedControllerLeaderMap = new HashMap<Integer, Pair<String, Integer>>();
    }

    public static void create(HelixManager helixManager) {
        if (_instance != null) {
            LOGGER.warn("Already created");
            return;
        }
        _instance = new ControllerLeaderLocator(helixManager);
    }

    public static ControllerLeaderLocator getInstance() {
        if (_instance == null) {
            throw new RuntimeException("Not yet created");
        }
        return _instance;
    }

    public synchronized Pair<String, Integer> getControllerLeader(String rawTableName) {
        int partitionId = LeadControllerUtils.getPartitionIdForTable((String)rawTableName);
        if (this._cachedControllerLeaderValid) {
            return this._cachedControllerLeaderMap.get(partitionId);
        }
        this.refreshControllerLeaderMap();
        return this._cachedControllerLeaderValid ? this._cachedControllerLeaderMap.get(partitionId) : null;
    }

    private void refreshControllerLeaderMap() {
        try {
            if (LeadControllerUtils.isLeadControllerResourceEnabled((HelixManager)this._helixManager)) {
                this.refreshControllerLeaderMapFromLeadControllerResource();
            } else {
                this.refreshControllerLeaderMapFromHelixClusterLeader();
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception when checking whether lead controller resource is enable or not.", (Throwable)e);
        }
    }

    private void refreshControllerLeaderMapFromLeadControllerResource() {
        try {
            HelixDataAccessor dataAccessor = this._helixManager.getHelixDataAccessor();
            PropertyKey.Builder keyBuilder = dataAccessor.keyBuilder();
            ExternalView leadControllerResourceExternalView = (ExternalView)dataAccessor.getProperty(keyBuilder.externalView("leadControllerResource"));
            if (leadControllerResourceExternalView == null) {
                LOGGER.error("External view of {} is null.", (Object)"leadControllerResource");
                return;
            }
            Map partitionStateMap = leadControllerResourceExternalView.getRecord().getMapFields();
            if (partitionStateMap.size() != 24) {
                LOGGER.error("The partition size of {} is not {}. Actual size: {}", new Object[]{"leadControllerResource", 24, partitionStateMap.size()});
                return;
            }
            for (Map.Entry entry : partitionStateMap.entrySet()) {
                String partitionName = (String)entry.getKey();
                Map instanceStateMap = (Map)entry.getValue();
                String masterInstanceId = null;
                for (Map.Entry instanceStateEntry : instanceStateMap.entrySet()) {
                    if (!((String)instanceStateEntry.getValue()).equals(MasterSlaveSMD.States.MASTER.name())) continue;
                    masterInstanceId = (String)instanceStateEntry.getKey();
                    break;
                }
                if (masterInstanceId == null) {
                    LOGGER.warn("There is no controller in MASTER state for partition: {} in {}", (Object)partitionName, (Object)"leadControllerResource");
                    return;
                }
                InstanceConfig instanceConfig = (InstanceConfig)dataAccessor.getProperty(keyBuilder.instanceConfig(masterInstanceId));
                if (instanceConfig == null) {
                    LOGGER.error("Failed to find instance config for MASTER controller: {}", (Object)masterInstanceId);
                    return;
                }
                int partitionId = LeadControllerUtils.extractPartitionId((String)partitionName);
                Pair hostnamePortPair = new Pair((Serializable)((Object)instanceConfig.getHostName()), (Serializable)Integer.valueOf(Integer.parseInt(instanceConfig.getPort())));
                this._cachedControllerLeaderMap.put(partitionId, (Pair<String, Integer>)hostnamePortPair);
            }
            this._cachedControllerLeaderValid = true;
            LOGGER.info("Refreshed controller leader map successfully.");
        }
        catch (Exception e) {
            LOGGER.error("Caught exception when getting lead controller instance Id from external view of {}", (Object)"leadControllerResource", (Object)e);
        }
    }

    private void refreshControllerLeaderMapFromHelixClusterLeader() {
        Pair<String, Integer> helixClusterLeader = this.getHelixClusterLeader();
        if (helixClusterLeader == null) {
            LOGGER.error("Failed to refresh the controller leader map.");
            return;
        }
        for (int i = 0; i < 24; ++i) {
            this._cachedControllerLeaderMap.put(i, helixClusterLeader);
        }
        this._cachedControllerLeaderValid = true;
        LOGGER.info("Refreshed controller leader map successfully.");
    }

    private Pair<String, Integer> getHelixClusterLeader() {
        String helixLeader = LeadControllerUtils.getHelixClusterLeader((HelixManager)this._helixManager);
        return this.convertToHostAndPortPair(helixLeader);
    }

    private Pair<String, Integer> convertToHostAndPortPair(String instanceId) {
        if (instanceId == null) {
            return null;
        }
        int index = instanceId.lastIndexOf(95);
        String leaderHost = instanceId.substring(0, index);
        int leaderPort = Integer.parseInt(instanceId.substring(index + 1));
        return new Pair((Serializable)((Object)leaderHost), (Serializable)Integer.valueOf(leaderPort));
    }

    public synchronized void invalidateCachedControllerLeader() {
        long now = this.getCurrentTimeMs();
        long millisSinceLastInvalidate = now - this._lastCacheInvalidationTimeMs;
        if (millisSinceLastInvalidate < 30000L) {
            LOGGER.info("Millis since last controller cache value invalidate {} is less than allowed frequency {}. Skipping invalidate.", (Object)millisSinceLastInvalidate, (Object)30000L);
        } else {
            LOGGER.info("Invalidating cached controller leader value");
            this._cachedControllerLeaderValid = false;
            this._lastCacheInvalidationTimeMs = now;
        }
    }

    @VisibleForTesting
    protected long getCurrentTimeMs() {
        return System.currentTimeMillis();
    }

    @VisibleForTesting
    protected boolean isCachedControllerLeaderValid() {
        return this._cachedControllerLeaderValid;
    }

    @VisibleForTesting
    protected long getLastCacheInvalidationTimeMs() {
        return this._lastCacheInvalidationTimeMs;
    }

    @VisibleForTesting
    protected long getMinInvalidateIntervalMs() {
        return 30000L;
    }
}

