/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo.index;

import com.facebook.presto.accumulo.AccumuloErrorCode;
import com.facebook.presto.accumulo.Types;
import com.facebook.presto.accumulo.iterators.MaxByteArrayCombiner;
import com.facebook.presto.accumulo.iterators.MinByteArrayCombiner;
import com.facebook.presto.accumulo.metadata.AccumuloTable;
import com.facebook.presto.accumulo.model.AccumuloColumnHandle;
import com.facebook.presto.accumulo.serializers.AccumuloRowSerializer;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.primitives.UnsignedBytes;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.LongCombiner;
import org.apache.accumulo.core.iterators.TypedValueCombiner;
import org.apache.accumulo.core.iterators.user.SummingCombiner;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.io.Text;

@NotThreadSafe
public class Indexer
implements Closeable {
    public static final ByteBuffer METRICS_TABLE_ROW_ID = ByteBuffer.wrap("___METRICS_TABLE___".getBytes(StandardCharsets.UTF_8));
    public static final ByteBuffer METRICS_TABLE_ROWS_CF = ByteBuffer.wrap("___rows___".getBytes(StandardCharsets.UTF_8));
    public static final MetricsKey METRICS_TABLE_ROW_COUNT = new MetricsKey(METRICS_TABLE_ROW_ID, METRICS_TABLE_ROWS_CF);
    public static final ByteBuffer METRICS_TABLE_FIRST_ROW_CQ = ByteBuffer.wrap("___first_row___".getBytes(StandardCharsets.UTF_8));
    public static final ByteBuffer METRICS_TABLE_LAST_ROW_CQ = ByteBuffer.wrap("___last_row___".getBytes(StandardCharsets.UTF_8));
    public static final byte[] CARDINALITY_CQ = "___card___".getBytes(StandardCharsets.UTF_8);
    public static final Text CARDINALITY_CQ_AS_TEXT = new Text(CARDINALITY_CQ);
    public static final Text METRICS_TABLE_ROWS_CF_AS_TEXT = new Text(METRICS_TABLE_ROWS_CF.array());
    public static final Text METRICS_TABLE_ROWID_AS_TEXT = new Text(METRICS_TABLE_ROW_ID.array());
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final byte UNDERSCORE = 95;
    private static final TypedValueCombiner.Encoder<Long> ENCODER = new LongCombiner.StringEncoder();
    private final AccumuloTable table;
    private final BatchWriter indexWriter;
    private final BatchWriterConfig writerConfig;
    private final Connector connector;
    private final Map<MetricsKey, AtomicLong> metrics = new HashMap<MetricsKey, AtomicLong>();
    private final Multimap<ByteBuffer, ByteBuffer> indexColumns;
    private final Map<ByteBuffer, Map<ByteBuffer, Type>> indexColumnTypes;
    private final AccumuloRowSerializer serializer;
    private final Comparator<byte[]> byteArrayComparator = UnsignedBytes.lexicographicalComparator();
    private byte[] firstRow;
    private byte[] lastRow;

    public Indexer(Connector connector, Authorizations auths, AccumuloTable table, BatchWriterConfig writerConfig) throws TableNotFoundException {
        this.connector = Objects.requireNonNull(connector, "connector is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.writerConfig = Objects.requireNonNull(writerConfig, "writerConfig is null");
        Objects.requireNonNull(auths, "auths is null");
        this.serializer = table.getSerializerInstance();
        this.indexWriter = connector.createBatchWriter(table.getIndexTableName(), writerConfig);
        ImmutableMultimap.Builder indexColumnsBuilder = ImmutableMultimap.builder();
        HashMap indexColumnTypesBuilder = new HashMap();
        table.getColumns().forEach(columnHandle -> {
            if (columnHandle.isIndexed()) {
                ByteBuffer family = ByteBuffer.wrap(columnHandle.getFamily().get().getBytes(StandardCharsets.UTF_8));
                ByteBuffer qualifier = ByteBuffer.wrap(columnHandle.getQualifier().get().getBytes(StandardCharsets.UTF_8));
                indexColumnsBuilder.put((Object)family, (Object)qualifier);
                HashMap<ByteBuffer, Type> types = (HashMap<ByteBuffer, Type>)indexColumnTypesBuilder.get(family);
                if (types == null) {
                    types = new HashMap<ByteBuffer, Type>();
                    indexColumnTypesBuilder.put(family, types);
                }
                types.put(qualifier, columnHandle.getType());
            }
        });
        this.indexColumns = indexColumnsBuilder.build();
        this.indexColumnTypes = ImmutableMap.copyOf(indexColumnTypesBuilder);
        if (this.indexColumns.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "No indexed columns in table metadata. Refusing to index a table with no indexed columns");
        }
        this.metrics.put(METRICS_TABLE_ROW_COUNT, new AtomicLong(0L));
        Pair<byte[], byte[]> minmax = Indexer.getMinMaxRowIds(connector, table, auths);
        this.firstRow = (byte[])minmax.getLeft();
        this.lastRow = (byte[])minmax.getRight();
    }

    public void index(Mutation mutation) {
        this.metrics.get(METRICS_TABLE_ROW_COUNT).incrementAndGet();
        if (this.firstRow == null || this.byteArrayComparator.compare(mutation.getRow(), this.firstRow) < 0) {
            this.firstRow = mutation.getRow();
        }
        if (this.lastRow == null || this.byteArrayComparator.compare(mutation.getRow(), this.lastRow) > 0) {
            this.lastRow = mutation.getRow();
        }
        for (ColumnUpdate columnUpdate : mutation.getUpdates()) {
            ByteBuffer qualifier;
            ByteBuffer family = ByteBuffer.wrap(columnUpdate.getColumnFamily());
            Collection indexQualifiers = this.indexColumns.get((Object)family);
            if (indexQualifiers == null || !indexQualifiers.contains(qualifier = ByteBuffer.wrap(columnUpdate.getColumnQualifier()))) continue;
            ByteBuffer indexFamily = Indexer.getIndexColumnFamily(columnUpdate.getColumnFamily(), columnUpdate.getColumnQualifier());
            Type type = this.indexColumnTypes.get(family).get(qualifier);
            ColumnVisibility visibility = new ColumnVisibility(columnUpdate.getColumnVisibility());
            if (Types.isArrayType(type)) {
                Type elementType = Types.getElementType(type);
                List elements = (List)this.serializer.decode(type, columnUpdate.getValue());
                for (Object element : elements) {
                    this.addIndexMutation(ByteBuffer.wrap(this.serializer.encode(elementType, element)), indexFamily, visibility, mutation.getRow());
                }
                continue;
            }
            this.addIndexMutation(ByteBuffer.wrap(columnUpdate.getValue()), indexFamily, visibility, mutation.getRow());
        }
    }

    public void index(Iterable<Mutation> mutations) {
        for (Mutation mutation : mutations) {
            this.index(mutation);
        }
    }

    private void addIndexMutation(ByteBuffer row, ByteBuffer family, ColumnVisibility visibility, byte[] qualifier) {
        Mutation indexMutation = new Mutation(row.array());
        indexMutation.put(family.array(), qualifier, visibility, EMPTY_BYTES);
        try {
            this.indexWriter.addMutation(indexMutation);
        }
        catch (MutationsRejectedException e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.UNEXPECTED_ACCUMULO_ERROR, "Index mutation rejected by server", (Throwable)e);
        }
        MetricsKey key = new MetricsKey(row, family, visibility);
        AtomicLong count = this.metrics.get(key);
        if (count == null) {
            count = new AtomicLong(0L);
            this.metrics.put(key, count);
        }
        count.incrementAndGet();
    }

    public void flush() {
        try {
            this.indexWriter.flush();
            BatchWriter metricsWriter = this.connector.createBatchWriter(this.table.getMetricsTableName(), this.writerConfig);
            metricsWriter.addMutations(this.getMetricsMutations());
            metricsWriter.close();
            this.metrics.clear();
            this.metrics.put(METRICS_TABLE_ROW_COUNT, new AtomicLong(0L));
        }
        catch (MutationsRejectedException e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.UNEXPECTED_ACCUMULO_ERROR, "Index mutation was rejected by server on flush", (Throwable)e);
        }
        catch (TableNotFoundException e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.ACCUMULO_TABLE_DNE, "Accumulo table does not exist", (Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            this.flush();
            this.indexWriter.close();
        }
        catch (MutationsRejectedException e) {
            throw new PrestoException((ErrorCodeSupplier)AccumuloErrorCode.UNEXPECTED_ACCUMULO_ERROR, "Mutation was rejected by server on close", (Throwable)e);
        }
    }

    private Collection<Mutation> getMetricsMutations() {
        ImmutableList.Builder mutationBuilder = ImmutableList.builder();
        for (Map.Entry<MetricsKey, AtomicLong> entry : this.metrics.entrySet()) {
            Mutation mut = new Mutation(entry.getKey().row.array());
            mut.put(entry.getKey().family.array(), CARDINALITY_CQ, entry.getKey().visibility, ENCODER.encode((Object)entry.getValue().get()));
            mutationBuilder.add((Object)mut);
        }
        if (this.firstRow != null && this.lastRow != null) {
            Mutation firstLastMutation = new Mutation(METRICS_TABLE_ROW_ID.array());
            firstLastMutation.put(METRICS_TABLE_ROWS_CF.array(), METRICS_TABLE_FIRST_ROW_CQ.array(), this.firstRow);
            firstLastMutation.put(METRICS_TABLE_ROWS_CF.array(), METRICS_TABLE_LAST_ROW_CQ.array(), this.lastRow);
            mutationBuilder.add((Object)firstLastMutation);
        }
        return mutationBuilder.build();
    }

    public static Collection<IteratorSetting> getMetricIterators(AccumuloTable table) {
        String cardQualifier = new String(CARDINALITY_CQ);
        String rowsFamily = new String(METRICS_TABLE_ROWS_CF.array());
        StringBuilder cardBuilder = new StringBuilder(rowsFamily + ":" + cardQualifier + ",");
        for (String s : Indexer.getLocalityGroups(table).keySet()) {
            cardBuilder.append(s).append(":").append(cardQualifier).append(',');
        }
        cardBuilder.deleteCharAt(cardBuilder.length() - 1);
        String firstRowColumn = rowsFamily + ":" + new String(METRICS_TABLE_FIRST_ROW_CQ.array());
        String lastRowColumn = rowsFamily + ":" + new String(METRICS_TABLE_LAST_ROW_CQ.array());
        IteratorSetting s1 = new IteratorSetting(1, SummingCombiner.class, (Map)ImmutableMap.of((Object)"columns", (Object)cardBuilder.toString(), (Object)"type", (Object)"STRING"));
        IteratorSetting s2 = new IteratorSetting(2, MinByteArrayCombiner.class, (Map)ImmutableMap.of((Object)"columns", (Object)firstRowColumn));
        IteratorSetting s3 = new IteratorSetting(3, MaxByteArrayCombiner.class, (Map)ImmutableMap.of((Object)"columns", (Object)lastRowColumn));
        return ImmutableList.of((Object)s1, (Object)s2, (Object)s3);
    }

    public static ByteBuffer getIndexColumnFamily(byte[] columnFamily, byte[] columnQualifier) {
        return ByteBuffer.wrap(ArrayUtils.addAll((byte[])ArrayUtils.add((byte[])columnFamily, (byte)95), (byte[])columnQualifier));
    }

    public static Map<String, Set<Text>> getLocalityGroups(AccumuloTable table) {
        HashMap<String, Set<Text>> groups = new HashMap<String, Set<Text>>();
        for (AccumuloColumnHandle columnHandle : table.getColumns().stream().filter(AccumuloColumnHandle::isIndexed).collect(Collectors.toList())) {
            Text indexColumnFamily = new Text(Indexer.getIndexColumnFamily(columnHandle.getFamily().get().getBytes(StandardCharsets.UTF_8), columnHandle.getQualifier().get().getBytes(StandardCharsets.UTF_8)).array());
            groups.put(indexColumnFamily.toString(), (Set<Text>)ImmutableSet.of((Object)indexColumnFamily));
        }
        return groups;
    }

    public static String getIndexTableName(String schema, String table) {
        return schema.equals("default") ? table + "_idx" : schema + '.' + table + "_idx";
    }

    public static String getIndexTableName(SchemaTableName tableName) {
        return Indexer.getIndexTableName(tableName.getSchemaName(), tableName.getTableName());
    }

    public static String getMetricsTableName(String schema, String table) {
        return schema.equals("default") ? table + "_idx_metrics" : schema + '.' + table + "_idx_metrics";
    }

    public static String getMetricsTableName(SchemaTableName tableName) {
        return Indexer.getMetricsTableName(tableName.getSchemaName(), tableName.getTableName());
    }

    public static Pair<byte[], byte[]> getMinMaxRowIds(Connector connector, AccumuloTable table, Authorizations auths) throws TableNotFoundException {
        Scanner scanner = connector.createScanner(table.getMetricsTableName(), auths);
        scanner.setRange(new Range(new Text(METRICS_TABLE_ROW_ID.array())));
        Text family = new Text(METRICS_TABLE_ROWS_CF.array());
        Text firstRowQualifier = new Text(METRICS_TABLE_FIRST_ROW_CQ.array());
        Text lastRowQualifier = new Text(METRICS_TABLE_LAST_ROW_CQ.array());
        scanner.fetchColumn(family, firstRowQualifier);
        scanner.fetchColumn(family, lastRowQualifier);
        byte[] firstRow = null;
        byte[] lastRow = null;
        for (Map.Entry entry : scanner) {
            if (((Key)entry.getKey()).compareColumnQualifier(firstRowQualifier) == 0) {
                firstRow = ((Value)entry.getValue()).get();
            }
            if (((Key)entry.getKey()).compareColumnQualifier(lastRowQualifier) != 0) continue;
            lastRow = ((Value)entry.getValue()).get();
        }
        scanner.close();
        return Pair.of(firstRow, lastRow);
    }

    private static class MetricsKey {
        private static final ColumnVisibility EMPTY_VISIBILITY = new ColumnVisibility();
        public final ByteBuffer row;
        public final ByteBuffer family;
        public final ColumnVisibility visibility;

        public MetricsKey(ByteBuffer row, ByteBuffer family) {
            Objects.requireNonNull(row, "row is null");
            Objects.requireNonNull(family, "family is null");
            this.row = row;
            this.family = family;
            this.visibility = EMPTY_VISIBILITY;
        }

        public MetricsKey(ByteBuffer row, ByteBuffer family, ColumnVisibility visibility) {
            Objects.requireNonNull(row, "row is null");
            Objects.requireNonNull(family, "family is null");
            Objects.requireNonNull(visibility, "visibility is null");
            this.row = row;
            this.family = family;
            this.visibility = visibility.getExpression() != null ? visibility : EMPTY_VISIBILITY;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MetricsKey other = (MetricsKey)obj;
            return Objects.equals(this.row, other.row) && Objects.equals(this.family, other.family) && Objects.equals(this.visibility, other.visibility);
        }

        public int hashCode() {
            return Objects.hash(this.row, this.family, this.visibility);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("row", (Object)new String(this.row.array(), StandardCharsets.UTF_8)).add("family", (Object)new String(this.row.array(), StandardCharsets.UTF_8)).add("visibility", (Object)this.visibility.toString()).toString();
        }
    }
}

