/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo.io;

import com.facebook.presto.accumulo.AccumuloConnectorId;
import com.facebook.presto.accumulo.conf.AccumuloConfig;
import com.facebook.presto.accumulo.io.AccumuloRecordSet;
import com.facebook.presto.accumulo.model.AccumuloColumnHandle;
import com.facebook.presto.accumulo.model.AccumuloSplit;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.accumulo.core.client.Connector;

public class AccumuloRecordSetProvider
implements ConnectorRecordSetProvider {
    private final Connector connector;
    private final String connectorId;
    private final String username;

    @Inject
    public AccumuloRecordSetProvider(Connector connector, AccumuloConnectorId connectorId, AccumuloConfig config) {
        this.connector = Objects.requireNonNull(connector, "connector is null");
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.username = Objects.requireNonNull(config, "config is null").getUsername();
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<? extends ColumnHandle> columns) {
        Objects.requireNonNull(split, "split is null");
        Objects.requireNonNull(columns, "columns is null");
        AccumuloSplit accSplit = (AccumuloSplit)split;
        Preconditions.checkArgument((boolean)accSplit.getConnectorId().equals(this.connectorId), (Object)"split is not for this connector");
        ImmutableList.Builder handles = ImmutableList.builder();
        for (ColumnHandle columnHandle : columns) {
            handles.add((Object)((AccumuloColumnHandle)columnHandle));
        }
        return new AccumuloRecordSet(this.connector, session, accSplit, this.username, (List<AccumuloColumnHandle>)handles.build());
    }
}

