/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.accumulo.model;

import com.facebook.presto.accumulo.model.AccumuloColumnHandle;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class RowSchema {
    private final List<AccumuloColumnHandle> columns = new ArrayList<AccumuloColumnHandle>();

    public RowSchema addRowId(String name, Type type) {
        this.columns.add(new AccumuloColumnHandle(name, Optional.empty(), Optional.empty(), type, this.columns.size(), "Accumulo row ID", false));
        return this;
    }

    public RowSchema addColumn(String prestoName, Optional<String> family, Optional<String> qualifier, Type type) {
        return this.addColumn(prestoName, family, qualifier, type, false);
    }

    public RowSchema addColumn(String prestoName, Optional<String> family, Optional<String> qualifier, Type type, boolean indexed) {
        this.columns.add(new AccumuloColumnHandle(prestoName, family, qualifier, type, this.columns.size(), String.format("Accumulo column %s:%s. Indexed: %b", family, qualifier, indexed), indexed));
        return this;
    }

    public AccumuloColumnHandle getColumn(int i) {
        Preconditions.checkArgument((i >= 0 && i < this.columns.size() ? 1 : 0) != 0, (Object)"column index must be non-negative and less than length");
        return this.columns.get(i);
    }

    public AccumuloColumnHandle getColumn(String name) {
        for (AccumuloColumnHandle columnHandle : this.columns) {
            if (!columnHandle.getName().equals(name)) continue;
            return columnHandle;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "No column with name " + name);
    }

    public List<AccumuloColumnHandle> getColumns() {
        return this.columns;
    }

    public int getLength() {
        return this.columns.size();
    }

    public static RowSchema fromColumns(List<AccumuloColumnHandle> columns) {
        RowSchema schema = new RowSchema();
        for (AccumuloColumnHandle columnHandle : columns) {
            schema.addColumn(columnHandle.getName(), columnHandle.getFamily(), columnHandle.getQualifier(), columnHandle.getType(), columnHandle.isIndexed());
        }
        return schema;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        for (AccumuloColumnHandle columnHandle : this.columns) {
            builder.append(columnHandle.getName()).append(' ').append(columnHandle.getType()).append(',');
        }
        if (builder.length() > 1) {
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append('}');
        return builder.toString();
    }
}

