/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.CacheContext;
import alluxio.client.file.cache.CacheManager;
import alluxio.client.file.cache.MetaStore;
import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.PageInfo;
import alluxio.client.file.cache.PageStore;
import alluxio.client.file.cache.QuotaMetaStore;
import alluxio.client.file.cache.store.PageStoreOptions;
import alluxio.client.quota.CacheQuota;
import alluxio.client.quota.CacheScope;
import alluxio.collections.ConcurrentHashSet;
import alluxio.collections.Pair;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.PageNotFoundException;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.resource.LockResource;
import alluxio.shaded.client.com.codahale.metrics.Counter;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.base.Throwables;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.GuardedBy;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LocalCacheManager
implements CacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(LocalCacheManager.class);
    private static final int LOCK_SIZE = 1024;
    private final long mPageSize;
    private final long mCacheSize;
    private final int mMaxEvictionRetries;
    private final boolean mAsyncWrite;
    private final boolean mAsyncRestore;
    private final ReadWriteLock[] mPageLocks = new ReentrantReadWriteLock[1024];
    private PageStore mPageStore;
    private final ReadWriteLock mMetaLock = new ReentrantReadWriteLock();
    @GuardedBy(value="mMetaLock")
    private final MetaStore mMetaStore;
    private final ExecutorService mInitService;
    private final ExecutorService mAsyncCacheExecutor;
    private final ConcurrentHashSet<PageId> mPendingRequests;
    private final boolean mQuotaEnabled;
    private final AtomicReference<CacheManager.State> mState = new AtomicReference();

    public static LocalCacheManager create(AlluxioConfiguration conf) throws IOException {
        PageStore pageStore;
        MetaStore metaStore = MetaStore.create(conf);
        PageStoreOptions options = PageStoreOptions.create(conf);
        try {
            pageStore = PageStore.open(options);
        }
        catch (IOException e) {
            pageStore = PageStore.create(options);
        }
        return LocalCacheManager.create(conf, metaStore, pageStore);
    }

    @VisibleForTesting
    static LocalCacheManager create(AlluxioConfiguration conf, MetaStore metaStore, PageStore pageStore) throws IOException {
        LocalCacheManager manager = new LocalCacheManager(conf, metaStore, pageStore);
        PageStoreOptions options = PageStoreOptions.create(conf);
        if (conf.getBoolean(PropertyKey.USER_CLIENT_CACHE_ASYNC_RESTORE_ENABLED)) {
            manager.mInitService.submit(() -> {
                try {
                    manager.restoreOrInit(options);
                }
                catch (IOException e) {
                    LOG.error("Failed to restore LocalCacheManager", (Throwable)e);
                }
            });
        } else {
            manager.restoreOrInit(options);
        }
        return manager;
    }

    @VisibleForTesting
    LocalCacheManager(AlluxioConfiguration conf, MetaStore metaStore, PageStore pageStore) {
        this.mMetaStore = metaStore;
        this.mPageStore = pageStore;
        this.mPageSize = conf.getBytes(PropertyKey.USER_CLIENT_CACHE_PAGE_SIZE);
        this.mAsyncWrite = conf.getBoolean(PropertyKey.USER_CLIENT_CACHE_ASYNC_WRITE_ENABLED);
        this.mAsyncRestore = conf.getBoolean(PropertyKey.USER_CLIENT_CACHE_ASYNC_RESTORE_ENABLED);
        this.mMaxEvictionRetries = conf.getInt(PropertyKey.USER_CLIENT_CACHE_EVICTION_RETRIES);
        this.mCacheSize = pageStore.getCacheSize();
        for (int i = 0; i < 1024; ++i) {
            this.mPageLocks[i] = new ReentrantReadWriteLock(true);
        }
        this.mPendingRequests = new ConcurrentHashSet();
        this.mAsyncCacheExecutor = this.mAsyncWrite ? new ThreadPoolExecutor(conf.getInt(PropertyKey.USER_CLIENT_CACHE_ASYNC_WRITE_THREADS), conf.getInt(PropertyKey.USER_CLIENT_CACHE_ASYNC_WRITE_THREADS), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>()) : null;
        this.mInitService = this.mAsyncRestore ? Executors.newSingleThreadExecutor() : null;
        this.mQuotaEnabled = conf.getBoolean(PropertyKey.USER_CLIENT_CACHE_QUOTA_ENABLED);
        Metrics.registerGauges(this.mCacheSize, this.mMetaStore);
        this.mState.set(CacheManager.State.READ_ONLY);
        Metrics.STATE.inc();
    }

    private int getPageLockId(PageId pageId) {
        return Math.floorMod((int)((long)pageId.getFileId().hashCode() + pageId.getPageIndex()), 1024);
    }

    private ReadWriteLock getPageLock(PageId pageId) {
        return this.mPageLocks[this.getPageLockId(pageId)];
    }

    private Pair<ReadWriteLock, ReadWriteLock> getPageLockPair(PageId pageId1, PageId pageId2) {
        int lockId2;
        int lockId1 = this.getPageLockId(pageId1);
        if (lockId1 < (lockId2 = this.getPageLockId(pageId2))) {
            return new Pair<ReadWriteLock, ReadWriteLock>(this.mPageLocks[lockId1], this.mPageLocks[lockId2]);
        }
        return new Pair<ReadWriteLock, ReadWriteLock>(this.mPageLocks[lockId2], this.mPageLocks[lockId1]);
    }

    @Nullable
    private CacheScope checkScopeToEvict(int pageSize, CacheScope scope, CacheQuota quota, boolean forcedToEvict) {
        if (this.mQuotaEnabled) {
            for (CacheScope currentScope = scope; currentScope != null; currentScope = currentScope.parent()) {
                if (((QuotaMetaStore)this.mMetaStore).bytes(currentScope) + (long)pageSize <= quota.getQuota(currentScope)) continue;
                return currentScope;
            }
        }
        if (forcedToEvict || this.mMetaStore.bytes() + (long)pageSize > this.mCacheSize) {
            return CacheScope.GLOBAL;
        }
        return null;
    }

    @Override
    public boolean put(PageId pageId, byte[] page, CacheContext cacheContext) {
        LOG.debug("put({},{} bytes) enters", (Object)pageId, (Object)page.length);
        if (this.mState.get() != CacheManager.State.READ_WRITE) {
            Metrics.PUT_NOT_READY_ERRORS.inc();
            Metrics.PUT_ERRORS.inc();
            return false;
        }
        if (!this.mAsyncWrite) {
            boolean ok = this.putInternal(pageId, page, cacheContext);
            LOG.debug("put({},{} bytes) exits: {}", new Object[]{pageId, page.length, ok});
            if (!ok) {
                Metrics.PUT_ERRORS.inc();
            }
            return ok;
        }
        if (!this.mPendingRequests.add(pageId)) {
            return false;
        }
        try {
            this.mAsyncCacheExecutor.submit(() -> {
                try {
                    boolean ok = this.putInternal(pageId, page, cacheContext);
                    if (!ok) {
                        Metrics.PUT_ERRORS.inc();
                    }
                }
                finally {
                    this.mPendingRequests.remove(pageId);
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.mPendingRequests.remove(pageId);
            Metrics.PUT_ASYNC_REJECTION_ERRORS.inc();
            Metrics.PUT_ERRORS.inc();
            LOG.debug("put({},{} bytes) fails due to full queue", (Object)pageId, (Object)page.length);
            return false;
        }
        LOG.debug("put({},{} bytes) exits with async write", (Object)pageId, (Object)page.length);
        return true;
    }

    private boolean putInternal(PageId pageId, byte[] page, CacheContext cacheContext) {
        PutResult result = PutResult.OK;
        boolean forcedToEvict = false;
        block5: for (int i = 0; i <= this.mMaxEvictionRetries; ++i) {
            result = this.putAttempt(pageId, page, cacheContext, forcedToEvict);
            switch (result) {
                case OK: {
                    return true;
                }
                case BENIGN_RACING: 
                case INSUFFICIENT_SPACE_EVICTED: {
                    continue block5;
                }
                case NO_SPACE_LEFT: {
                    forcedToEvict = true;
                    continue block5;
                }
                default: {
                    return false;
                }
            }
        }
        if (result == PutResult.BENIGN_RACING) {
            Metrics.PUT_BENIGN_RACING_ERRORS.inc();
        } else if (result == PutResult.INSUFFICIENT_SPACE_EVICTED) {
            Metrics.PUT_INSUFFICIENT_SPACE_ERRORS.inc();
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private PutResult putAttempt(PageId pageId, byte[] page, CacheContext cacheContext, boolean forcedToEvict) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void undoAddPage(PageId pageId) {
        try (LockResource r3 = new LockResource(this.mMetaLock.writeLock());){
            this.mMetaStore.removePage(pageId);
        }
        catch (Exception e) {
            Metrics.CLEANUP_PUT_ERRORS.inc();
            LOG.error("Failed to undo page add {}", (Object)pageId, (Object)e);
        }
    }

    @Override
    public int get(PageId pageId, int pageOffset, int bytesToRead, byte[] buffer, int offsetInBuffer, CacheContext cacheContext) {
        Preconditions.checkArgument((long)pageOffset <= this.mPageSize, "Read exceeds page boundary: offset=%s size=%s", pageOffset, this.mPageSize);
        Preconditions.checkArgument(bytesToRead <= buffer.length - offsetInBuffer, "buffer does not have enough space: bufferLength=%s offsetInBuffer=%s bytesToRead=%s", (Object)buffer.length, (Object)offsetInBuffer, (Object)bytesToRead);
        LOG.debug("get({},pageOffset={}) enters", (Object)pageId, (Object)pageOffset);
        if (this.mState.get() == CacheManager.State.NOT_IN_USE) {
            Metrics.GET_NOT_READY_ERRORS.inc();
            Metrics.GET_ERRORS.inc();
            return -1;
        }
        ReadWriteLock pageLock = this.getPageLock(pageId);
        try (LockResource r = new LockResource(pageLock.readLock());){
            try (LockResource r2 = new LockResource(this.mMetaLock.readLock());){
                this.mMetaStore.getPageInfo(pageId);
            }
            catch (PageNotFoundException e) {
                LOG.debug("get({},pageOffset={}) fails due to page not found", (Object)pageId, (Object)pageOffset);
                int n = 0;
                if (r != null) {
                    if (var9_9 != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable) {
                            var9_9.addSuppressed(throwable);
                        }
                    } else {
                        r.close();
                    }
                }
                return n;
            }
            int bytesRead = this.getPage(pageId, pageOffset, bytesToRead, buffer, offsetInBuffer);
            if (bytesRead <= 0) {
                Metrics.GET_ERRORS.inc();
                Metrics.GET_STORE_READ_ERRORS.inc();
                try (LockResource r2 = new LockResource(this.mMetaLock.writeLock());){
                    this.mMetaStore.removePage(pageId);
                }
                catch (PageNotFoundException e) {
                    Metrics.CLEANUP_GET_ERRORS.inc();
                }
                int n = -1;
                return n;
            }
            LOG.debug("get({},pageOffset={}) exits", (Object)pageId, (Object)pageOffset);
            int n = bytesRead;
            return n;
        }
    }

    @Override
    public boolean delete(PageId pageId) {
        LOG.debug("delete({}) enters", (Object)pageId);
        if (this.mState.get() != CacheManager.State.READ_WRITE) {
            Metrics.DELETE_NOT_READY_ERRORS.inc();
            Metrics.DELETE_ERRORS.inc();
            return false;
        }
        ReadWriteLock pageLock = this.getPageLock(pageId);
        try (LockResource r = new LockResource(pageLock.writeLock());){
            try (LockResource r1 = new LockResource(this.mMetaLock.writeLock());){
                try {
                    this.mMetaStore.removePage(pageId);
                }
                catch (PageNotFoundException e) {
                    LOG.error("Failed to delete page {} from metaStore ", (Object)pageId, (Object)e);
                    Metrics.DELETE_NON_EXISTING_PAGE_ERRORS.inc();
                    Metrics.DELETE_ERRORS.inc();
                    boolean bl = false;
                    if (r1 != null) {
                        if (var6_8 != null) {
                            try {
                                r1.close();
                            }
                            catch (Throwable throwable) {
                                var6_8.addSuppressed(throwable);
                            }
                        } else {
                            r1.close();
                        }
                    }
                    if (r != null) {
                        if (var4_4 != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            r.close();
                        }
                    }
                    return bl;
                }
            }
            boolean ok = this.deletePage(pageId);
            LOG.debug("delete({}) exits, success: {}", (Object)pageId, (Object)ok);
            if (!ok) {
                Metrics.DELETE_STORE_DELETE_ERRORS.inc();
                Metrics.DELETE_ERRORS.inc();
            }
            boolean bl = ok;
            return bl;
        }
    }

    @Override
    public CacheManager.State state() {
        return this.mState.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreOrInit(PageStoreOptions options) throws IOException {
        Class<LocalCacheManager> clazz = LocalCacheManager.class;
        synchronized (LocalCacheManager.class) {
            Preconditions.checkState(this.mState.get() == CacheManager.State.READ_ONLY);
            if (!this.restore(options)) {
                try (LockResource r = new LockResource(this.mMetaLock.writeLock());){
                    this.mMetaStore.reset();
                }
                try {
                    this.mPageStore.close();
                    this.mPageStore = PageStore.create(options);
                }
                catch (Exception e) {
                    LOG.error("Cache is in NOT_IN_USE.");
                    this.mState.set(CacheManager.State.NOT_IN_USE);
                    Metrics.STATE.dec();
                    Throwables.propagateIfPossible(e, IOException.class);
                    throw new IOException(e);
                }
            }
            LOG.info("Cache is in READ_WRITE.");
            this.mState.set(CacheManager.State.READ_WRITE);
            Metrics.STATE.inc();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean restore(PageStoreOptions options) {
        LOG.info("Restoring PageStore ({})", (Object)options);
        Path rootDir = Paths.get(options.getRootDir(), new String[0]);
        if (!Files.exists(rootDir, new LinkOption[0])) {
            LOG.error("Failed to restore PageStore: Directory {} does not exist", (Object)rootDir);
            return false;
        }
        long discardedPages = 0L;
        long discardedBytes = 0L;
        try (Stream<PageInfo> stream = this.mPageStore.getPages();){
            Iterator iterator = stream.iterator();
            while (iterator.hasNext()) {
                PageInfo pageInfo = (PageInfo)iterator.next();
                if (pageInfo == null) {
                    LOG.error("Failed to restore PageStore: Invalid page info");
                    boolean bl = false;
                    return bl;
                }
                PageId pageId = pageInfo.getPageId();
                ReadWriteLock pageLock = this.getPageLock(pageId);
                LockResource r = new LockResource(pageLock.writeLock());
                Throwable throwable = null;
                try {
                    boolean enoughSpace;
                    try (LockResource r2 = new LockResource(this.mMetaLock.writeLock());){
                        boolean bl = enoughSpace = this.mMetaStore.bytes() + pageInfo.getPageSize() <= this.mPageStore.getCacheSize();
                        if (enoughSpace) {
                            this.mMetaStore.addPage(pageId, pageInfo);
                        }
                    }
                    if (enoughSpace) continue;
                    this.mPageStore.delete(pageId);
                    ++discardedPages;
                    discardedBytes += pageInfo.getPageSize();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (r == null) continue;
                    if (throwable != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    r.close();
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to restore PageStore", (Throwable)e);
            return false;
        }
        LOG.info("PageStore ({}) restored with {} pages ({} bytes), discarded {} pages ({} bytes)", new Object[]{options, this.mMetaStore.pages(), this.mMetaStore.bytes(), discardedPages, discardedBytes});
        return true;
    }

    @Override
    public void close() throws Exception {
        this.mPageStore.close();
        this.mMetaStore.reset();
        if (this.mInitService != null) {
            this.mInitService.shutdownNow();
        }
        if (this.mAsyncCacheExecutor != null) {
            this.mAsyncCacheExecutor.shutdownNow();
        }
    }

    private boolean deletePage(PageId pageId) {
        try {
            this.mPageStore.delete(pageId);
        }
        catch (PageNotFoundException | IOException e) {
            LOG.error("Failed to delete page {} from pageStore", (Object)pageId, (Object)e);
            return false;
        }
        return true;
    }

    private int getPage(PageId pageId, int pageOffset, int bytesToRead, byte[] buffer, int bufferOffset) {
        try {
            int ret = this.mPageStore.get(pageId, pageOffset, bytesToRead, buffer, bufferOffset);
            if (ret != bytesToRead) {
                LOG.error("Failed to read page {}: supposed to read {} bytes, {} bytes actually read", new Object[]{pageId, bytesToRead, ret});
                return -1;
            }
        }
        catch (PageNotFoundException | IOException e) {
            LOG.error("Failed to get existing page {} from pageStore", (Object)pageId, (Object)e);
            return -1;
        }
        return bytesToRead;
    }

    private static final class Metrics {
        private static final Counter CLEANUP_GET_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_CLEANUP_GET_ERRORS.getName());
        private static final Counter CLEANUP_PUT_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_CLEANUP_PUT_ERRORS.getName());
        private static final Counter DELETE_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_DELETE_ERRORS.getName());
        private static final Counter DELETE_NON_EXISTING_PAGE_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_DELETE_NON_EXISTING_PAGE_ERRORS.getName());
        private static final Counter DELETE_NOT_READY_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_DELETE_NOT_READY_ERRORS.getName());
        private static final Counter DELETE_STORE_DELETE_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_DELETE_FROM_STORE_ERRORS.getName());
        private static final Counter GET_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_GET_ERRORS.getName());
        private static final Counter GET_NOT_READY_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_GET_NOT_READY_ERRORS.getName());
        private static final Counter GET_STORE_READ_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_GET_STORE_READ_ERRORS.getName());
        private static final Counter PUT_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_PUT_ERRORS.getName());
        private static final Counter PUT_ASYNC_REJECTION_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_PUT_ASYNC_REJECTION_ERRORS.getName());
        private static final Counter PUT_EVICTION_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_PUT_EVICTION_ERRORS.getName());
        private static final Counter PUT_BENIGN_RACING_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_PUT_BENIGN_RACING_ERRORS.getName());
        private static final Counter PUT_INSUFFICIENT_SPACE_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_PUT_INSUFFICIENT_SPACE_ERRORS.getName());
        private static final Counter PUT_NOT_READY_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_PUT_NOT_READY_ERRORS.getName());
        private static final Counter PUT_STORE_DELETE_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_PUT_STORE_DELETE_ERRORS.getName());
        private static final Counter PUT_STORE_WRITE_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_PUT_STORE_WRITE_ERRORS.getName());
        private static final Counter PUT_STORE_WRITE_NO_SPACE_ERRORS = MetricsSystem.counter(MetricKey.CLIENT_CACHE_PUT_STORE_WRITE_NO_SPACE_ERRORS.getName());
        private static final Counter STATE = MetricsSystem.counter(MetricKey.CLIENT_CACHE_STATE.getName());

        private Metrics() {
        }

        private static void registerGauges(long cacheSize, MetaStore metaStore) {
            MetricsSystem.registerGaugeIfAbsent(MetricsSystem.getMetricName(MetricKey.CLIENT_CACHE_SPACE_AVAILABLE.getName()), () -> cacheSize - metaStore.bytes());
            MetricsSystem.registerGaugeIfAbsent(MetricsSystem.getMetricName(MetricKey.CLIENT_CACHE_SPACE_USED.getName()), metaStore::bytes);
        }

        static /* synthetic */ Counter access$700() {
            return PUT_EVICTION_ERRORS;
        }

        static /* synthetic */ Counter access$800() {
            return PUT_STORE_WRITE_NO_SPACE_ERRORS;
        }

        static /* synthetic */ Counter access$900() {
            return PUT_STORE_WRITE_ERRORS;
        }

        static /* synthetic */ Counter access$1000() {
            return PUT_STORE_DELETE_ERRORS;
        }
    }

    static enum PutResult {
        BENIGN_RACING,
        INSUFFICIENT_SPACE_EVICTED,
        NO_SPACE_LEFT,
        OK,
        OTHER;

    }
}

