/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.rabbitmq.client.impl;

import alluxio.shaded.client.com.rabbitmq.client.Channel;
import alluxio.shaded.client.com.rabbitmq.client.impl.WorkPool;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public final class ConsumerWorkService {
    private static final int MAX_RUNNABLE_BLOCK_SIZE = 16;
    private static final int DEFAULT_NUM_THREADS = Runtime.getRuntime().availableProcessors() * 2;
    private final ExecutorService executor;
    private final boolean privateExecutor;
    private final WorkPool<Channel, Runnable> workPool;
    private final int shutdownTimeout;

    public ConsumerWorkService(ExecutorService executor, ThreadFactory threadFactory, int queueingTimeout, int shutdownTimeout) {
        this.privateExecutor = executor == null;
        this.executor = executor == null ? Executors.newFixedThreadPool(DEFAULT_NUM_THREADS, threadFactory) : executor;
        this.workPool = new WorkPool(queueingTimeout);
        this.shutdownTimeout = shutdownTimeout;
    }

    public ConsumerWorkService(ExecutorService executor, ThreadFactory threadFactory, int shutdownTimeout) {
        this(executor, threadFactory, -1, shutdownTimeout);
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public void shutdown() {
        this.workPool.unregisterAllKeys();
        if (this.privateExecutor) {
            this.executor.shutdown();
        }
    }

    public void stopWork(Channel channel) {
        this.workPool.unregisterKey(channel);
    }

    public void registerKey(Channel channel) {
        this.workPool.registerKey(channel);
    }

    public void setUnlimited(Channel channel, boolean unlimited) {
        if (unlimited) {
            this.workPool.unlimit(channel);
        } else {
            this.workPool.limit(channel);
        }
    }

    public void addWork(Channel channel, Runnable runnable) {
        if (this.workPool.addWorkItem(channel, runnable)) {
            this.executor.execute(new WorkPoolRunnable());
        }
    }

    public boolean usesPrivateExecutor() {
        return this.privateExecutor;
    }

    private final class WorkPoolRunnable
    implements Runnable {
        private WorkPoolRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int size = 16;
            ArrayList block = new ArrayList(size);
            try {
                Channel key = (Channel)ConsumerWorkService.this.workPool.nextWorkBlock(block, size);
                if (key == null) {
                    return;
                }
                try {
                    for (Runnable runnable : block) {
                        runnable.run();
                    }
                }
                finally {
                    if (ConsumerWorkService.this.workPool.finishWorkBlock(key)) {
                        ConsumerWorkService.this.executor.execute(new WorkPoolRunnable());
                    }
                }
            }
            catch (RuntimeException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

