/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.pinot.spi.config.BaseJsonConfig;
import org.apache.pinot.spi.utils.JsonUtils;

public class ConfigUtils {
    private static final Map<String, String> ENVIRONMENT_VARIABLES = System.getenv();

    private ConfigUtils() {
    }

    public static <T extends BaseJsonConfig> T applyConfigWithEnvVariables(T config) {
        JsonNode jsonNode;
        try {
            jsonNode = ConfigUtils.applyConfigWithEnvVariables(config.toJsonNode());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(String.format("Unable to apply environment variables on json config class [%s].", config.getClass().getName()), e);
        }
        try {
            return (T)((BaseJsonConfig)JsonUtils.jsonNodeToObject(jsonNode, config.getClass()));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to read JsonConfig to class [%s] after applying environment variables, jsonConfig is: '%s'.", config.getClass().getName(), jsonNode.toString()), e);
        }
    }

    private static JsonNode applyConfigWithEnvVariables(JsonNode jsonNode) {
        JsonNodeType nodeType = jsonNode.getNodeType();
        switch (nodeType) {
            case OBJECT: {
                if (jsonNode.isEmpty()) break;
                Iterator iterator = jsonNode.fields();
                while (iterator.hasNext()) {
                    Map.Entry next = (Map.Entry)iterator.next();
                    next.setValue(ConfigUtils.applyConfigWithEnvVariables((JsonNode)next.getValue()));
                }
                break;
            }
            case ARRAY: {
                if (!jsonNode.isArray()) break;
                ArrayNode arrayNode = (ArrayNode)jsonNode;
                for (int i = 0; i < arrayNode.size(); ++i) {
                    JsonNode arrayElement = arrayNode.get(i);
                    arrayNode.set(i, ConfigUtils.applyConfigWithEnvVariables(arrayElement));
                }
                break;
            }
            case STRING: {
                String field = jsonNode.asText();
                if (!field.startsWith("${") || !field.endsWith("}")) break;
                String[] envVarSplits = field.substring(2, field.length() - 1).split(":", 2);
                String envVarKey = envVarSplits[0];
                if (ENVIRONMENT_VARIABLES.containsKey(envVarKey)) {
                    return JsonNodeFactory.instance.textNode(ENVIRONMENT_VARIABLES.get(envVarKey));
                }
                if (envVarSplits.length > 1) {
                    return JsonNodeFactory.instance.textNode(envVarSplits[1]);
                }
                throw new RuntimeException("Missing environment Variable: " + envVarKey);
            }
        }
        return jsonNode;
    }
}

