/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.BaseJsonConfig;
import org.apache.pinot.spi.utils.DataSizeUtils;

public class QuotaConfig
extends BaseJsonConfig {
    private static final long INVALID_STORAGE_IN_BYTES = -1L;
    private static final double INVALID_MAX_QPS = -1.0;
    @JsonPropertyDescription(value="Storage allocated for this table, e.g. \"10G\"")
    private final String _storage;
    private final String _maxQueriesPerSecond;
    private final transient long _storageInBytes;
    private final transient double _maxQPS;

    @JsonCreator
    public QuotaConfig(@JsonProperty(value="storage") @Nullable String storage, @JsonProperty(value="maxQueriesPerSecond") @Nullable String maxQueriesPerSecond) {
        if (storage != null) {
            try {
                this._storageInBytes = DataSizeUtils.toBytes(storage);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid 'storage': " + storage);
            }
            this._storage = DataSizeUtils.fromBytes(this._storageInBytes);
        } else {
            this._storageInBytes = -1L;
            this._storage = null;
        }
        if (maxQueriesPerSecond != null) {
            try {
                this._maxQPS = Double.parseDouble(maxQueriesPerSecond);
                Preconditions.checkArgument((this._maxQPS > 0.0 ? 1 : 0) != 0);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid 'maxQueriesPerSecond': " + storage);
            }
            this._maxQueriesPerSecond = Double.toString(this._maxQPS);
        } else {
            this._maxQPS = -1.0;
            this._maxQueriesPerSecond = null;
        }
    }

    @Nullable
    public String getStorage() {
        return this._storage;
    }

    @Nullable
    public String getMaxQueriesPerSecond() {
        return this._maxQueriesPerSecond;
    }

    @JsonIgnore
    public long getStorageInBytes() {
        return this._storageInBytes;
    }

    @JsonIgnore
    public double getMaxQPS() {
        return this._maxQPS;
    }
}

