/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.BaseJsonConfig;

public class UpsertConfig
extends BaseJsonConfig {
    @JsonPropertyDescription(value="Upsert mode.")
    private final Mode _mode;
    @JsonPropertyDescription(value="Function to hash the primary key.")
    private final HashFunction _hashFunction;
    @JsonPropertyDescription(value="Partial update strategies.")
    private final Map<String, Strategy> _partialUpsertStrategies;
    @JsonPropertyDescription(value="default upsert strategy for partial mode")
    private final Strategy _defaultPartialUpsertStrategy;
    @JsonPropertyDescription(value="Column for upsert comparison, default to time column")
    private final String _comparisonColumn;

    @JsonCreator
    public UpsertConfig(@JsonProperty(value="mode", required=true) Mode mode, @JsonProperty(value="partialUpsertStrategies") @Nullable Map<String, Strategy> partialUpsertStrategies, @JsonProperty(value="defaultPartialUpsertStrategy") @Nullable Strategy defaultPartialUpsertStrategy, @JsonProperty(value="comparisonColumn") @Nullable String comparisonColumn, @JsonProperty(value="hashFunction") @Nullable HashFunction hashFunction) {
        Preconditions.checkArgument((mode != null ? 1 : 0) != 0, (Object)"Upsert mode must be configured");
        this._mode = mode;
        if (mode == Mode.PARTIAL) {
            this._partialUpsertStrategies = partialUpsertStrategies != null ? partialUpsertStrategies : new HashMap();
            this._defaultPartialUpsertStrategy = defaultPartialUpsertStrategy != null ? defaultPartialUpsertStrategy : Strategy.OVERWRITE;
        } else {
            this._partialUpsertStrategies = null;
            this._defaultPartialUpsertStrategy = null;
        }
        this._comparisonColumn = comparisonColumn;
        this._hashFunction = hashFunction == null ? HashFunction.NONE : hashFunction;
    }

    public Mode getMode() {
        return this._mode;
    }

    public HashFunction getHashFunction() {
        return this._hashFunction;
    }

    @Nullable
    public Map<String, Strategy> getPartialUpsertStrategies() {
        return this._partialUpsertStrategies;
    }

    public Strategy getDefaultPartialUpsertStrategy() {
        return this._defaultPartialUpsertStrategy;
    }

    public String getComparisonColumn() {
        return this._comparisonColumn;
    }

    public static enum HashFunction {
        NONE,
        MD5,
        MURMUR3;

    }

    public static enum Strategy {
        APPEND,
        IGNORE,
        INCREMENT,
        OVERWRITE,
        UNION;

    }

    public static enum Mode {
        FULL,
        PARTIAL,
        NONE;

    }
}

