/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.pinot.spi.data.FieldSpec;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ComplexFieldSpec
extends FieldSpec {
    private final Map<String, FieldSpec> _childFieldSpecs;

    public ComplexFieldSpec() {
        this._childFieldSpecs = new HashMap<String, FieldSpec>();
    }

    public ComplexFieldSpec(@Nonnull String name, FieldSpec.DataType dataType, boolean isSingleValueField) {
        super(name, dataType, isSingleValueField);
        Preconditions.checkArgument((dataType == FieldSpec.DataType.STRUCT || dataType == FieldSpec.DataType.MAP || dataType == FieldSpec.DataType.LIST ? 1 : 0) != 0);
        this._childFieldSpecs = new HashMap<String, FieldSpec>();
    }

    public FieldSpec getChildFieldSpec(String child) {
        return this._childFieldSpecs.get(child);
    }

    public void addChildFieldSpec(String child, FieldSpec fieldSpec) {
        this._childFieldSpecs.put(child, fieldSpec);
    }

    public Map<String, FieldSpec> getChildFieldSpecs() {
        return this._childFieldSpecs;
    }

    @Override
    @JsonIgnore
    @Nonnull
    public FieldSpec.FieldType getFieldType() {
        return FieldSpec.FieldType.COMPLEX;
    }

    public String toString() {
        return "field type: COMPLEX, field name: " + this._name + ", root data type: " + (Object)((Object)this._dataType);
    }
}

