/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data;

import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.utils.EqualityUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateTimeFormatPatternSpec {
    private static final Pattern SDF_PATTERN_WITH_TIMEZONE = Pattern.compile("^(.+)( tz[ ]*\\((.+)\\))[ ]*");
    private static final int SDF_PATTERN_GROUP = 1;
    private static final int TIMEZONE_GROUP = 3;
    public static final DateTimeZone DEFAULT_DATETIMEZONE = DateTimeZone.UTC;
    public static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private final DateTimeFieldSpec.TimeFormat _timeFormat;
    private String _sdfPattern = null;
    private DateTimeZone _dateTimeZone = DEFAULT_DATETIMEZONE;
    private transient DateTimeFormatter _dateTimeFormatter;

    public DateTimeFormatPatternSpec(String timeFormat) {
        this(timeFormat, null);
    }

    public DateTimeFormatPatternSpec(String timeFormat, @Nullable String sdfPatternWithTz) {
        this._timeFormat = DateTimeFieldSpec.TimeFormat.valueOf(timeFormat);
        if (this._timeFormat.equals((Object)DateTimeFieldSpec.TimeFormat.SIMPLE_DATE_FORMAT)) {
            Preconditions.checkNotNull((Object)sdfPatternWithTz, (Object)String.format("Must provide simple date format pattern with time format type: %s", timeFormat));
            Matcher m = SDF_PATTERN_WITH_TIMEZONE.matcher(sdfPatternWithTz);
            if (m.find()) {
                this._sdfPattern = m.group(1).trim();
                String timezoneString = m.group(3).trim();
                this._dateTimeZone = DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(timezoneString));
            } else {
                this._sdfPattern = sdfPatternWithTz;
            }
            this._dateTimeFormatter = DateTimeFormat.forPattern((String)this._sdfPattern).withZone(this._dateTimeZone).withLocale(DEFAULT_LOCALE);
        }
    }

    public DateTimeFieldSpec.TimeFormat getTimeFormat() {
        return this._timeFormat;
    }

    public String getSdfPattern() {
        return this._sdfPattern;
    }

    public DateTimeZone getDateTimeZone() {
        return this._dateTimeZone;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return this._dateTimeFormatter;
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        DateTimeFormatPatternSpec that = (DateTimeFormatPatternSpec)o;
        return EqualityUtils.isEqual((Object)this._timeFormat, (Object)that._timeFormat) && EqualityUtils.isEqual(this._sdfPattern, that._sdfPattern) && EqualityUtils.isEqual(this._dateTimeZone, that._dateTimeZone);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf((Object)this._timeFormat);
        result = EqualityUtils.hashCodeOf(result, this._sdfPattern);
        result = EqualityUtils.hashCodeOf(result, this._dateTimeZone);
        return result;
    }

    public String toString() {
        return "DateTimeFormatPatternSpec{_timeFormat=" + (Object)((Object)this._timeFormat) + ", _sdfPattern='" + this._sdfPattern + '\'' + ", _dateTimeZone=" + this._dateTimeZone + ", _dateTimeFormatter=" + this._dateTimeFormatter + '}';
    }
}

