/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatPatternSpec;
import org.apache.pinot.spi.data.DateTimeFormatUnitSpec;
import org.apache.pinot.spi.utils.EqualityUtils;
import org.apache.pinot.spi.utils.TimestampUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;

public class DateTimeFormatSpec {
    public static final String NUMBER_REGEX = "[1-9][0-9]*";
    public static final String COLON_SEPARATOR = ":";
    public static final int FORMAT_SIZE_POSITION = 0;
    public static final int FORMAT_UNIT_POSITION = 1;
    public static final int FORMAT_TIMEFORMAT_POSITION = 2;
    public static final int FORMAT_PATTERN_POSITION = 3;
    public static final int MIN_FORMAT_TOKENS = 3;
    public static final int MAX_FORMAT_TOKENS = 4;
    private final String _format;
    private final int _size;
    private final DateTimeFormatUnitSpec _unitSpec;
    private final DateTimeFormatPatternSpec _patternSpec;

    public DateTimeFormatSpec(String format) {
        this._format = format;
        DateTimeFormatSpec.validateFormat(format);
        String[] formatTokens = StringUtils.split((String)format, (String)COLON_SEPARATOR, (int)4);
        this._patternSpec = formatTokens.length == 4 ? new DateTimeFormatPatternSpec(formatTokens[2], formatTokens[3]) : new DateTimeFormatPatternSpec(formatTokens[2]);
        if (this._patternSpec.getTimeFormat() == DateTimeFieldSpec.TimeFormat.TIMESTAMP) {
            this._size = 1;
            this._unitSpec = new DateTimeFormatUnitSpec("MILLISECONDS");
        } else {
            this._size = Integer.parseInt(formatTokens[0]);
            this._unitSpec = new DateTimeFormatUnitSpec(formatTokens[1]);
        }
    }

    public DateTimeFormatSpec(int columnSize, String columnUnit, String columnTimeFormat) {
        this._format = Joiner.on((String)COLON_SEPARATOR).join((Object)columnSize, (Object)columnUnit, new Object[]{columnTimeFormat});
        DateTimeFormatSpec.validateFormat(this._format);
        this._size = columnSize;
        this._unitSpec = new DateTimeFormatUnitSpec(columnUnit);
        this._patternSpec = new DateTimeFormatPatternSpec(columnTimeFormat);
    }

    public DateTimeFormatSpec(int columnSize, String columnUnit, String columnTimeFormat, String sdfPattern) {
        this._format = Joiner.on((String)COLON_SEPARATOR).join((Object)columnSize, (Object)columnUnit, new Object[]{columnTimeFormat, sdfPattern});
        DateTimeFormatSpec.validateFormat(this._format);
        this._size = columnSize;
        this._unitSpec = new DateTimeFormatUnitSpec(columnUnit);
        this._patternSpec = new DateTimeFormatPatternSpec(columnTimeFormat, sdfPattern);
    }

    public String getFormat() {
        return this._format;
    }

    public int getColumnSize() {
        return this._size;
    }

    public TimeUnit getColumnUnit() {
        return this._unitSpec.getTimeUnit();
    }

    public DateTimeFormatUnitSpec.DateTimeTransformUnit getColumnDateTimeTransformUnit() {
        return this._unitSpec.getDateTimeTransformUnit();
    }

    public DateTimeFieldSpec.TimeFormat getTimeFormat() {
        return this._patternSpec.getTimeFormat();
    }

    public String getSDFPattern() {
        return this._patternSpec.getSdfPattern();
    }

    public DateTimeZone getDateTimezone() {
        return this._patternSpec.getDateTimeZone();
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return this._patternSpec.getDateTimeFormatter();
    }

    public String fromMillisToFormat(long timeMs) {
        switch (this._patternSpec.getTimeFormat()) {
            case EPOCH: {
                return Long.toString(this._unitSpec.getTimeUnit().convert(timeMs, TimeUnit.MILLISECONDS) / (long)this._size);
            }
            case TIMESTAMP: {
                return new Timestamp(timeMs).toString();
            }
            case SIMPLE_DATE_FORMAT: {
                return this._patternSpec.getDateTimeFormatter().print(timeMs);
            }
        }
        throw new IllegalStateException("Unsupported time format: " + (Object)((Object)this._patternSpec.getTimeFormat()));
    }

    public long fromFormatToMillis(String dateTimeValue) {
        switch (this._patternSpec.getTimeFormat()) {
            case EPOCH: {
                return TimeUnit.MILLISECONDS.convert(Long.parseLong(dateTimeValue) * (long)this._size, this._unitSpec.getTimeUnit());
            }
            case TIMESTAMP: {
                return TimestampUtils.toMillisSinceEpoch(dateTimeValue);
            }
            case SIMPLE_DATE_FORMAT: {
                return this._patternSpec.getDateTimeFormatter().parseMillis(dateTimeValue);
            }
        }
        throw new IllegalStateException("Unsupported time format: " + (Object)((Object)this._patternSpec.getTimeFormat()));
    }

    public static void validateFormat(String format) {
        Preconditions.checkNotNull((Object)format, (Object)"Format string in dateTimeFieldSpec must not be null");
        String[] formatTokens = StringUtils.split((String)format, (String)COLON_SEPARATOR, (int)4);
        Preconditions.checkState((formatTokens.length >= 3 && formatTokens.length <= 4 ? 1 : 0) != 0, (String)"Incorrect format: %s. Must be of format 'size:timeunit:timeformat(:pattern)'", (Object)format);
        Preconditions.checkState((boolean)formatTokens[0].matches(NUMBER_REGEX), (String)"Incorrect format size: %s in format: %s. Must be of format '[0-9]+:<TimeUnit>:<TimeFormat>(:pattern)'", (Object)formatTokens[0], (Object)format);
        DateTimeFormatUnitSpec.validateUnitSpec(formatTokens[1]);
        if (formatTokens.length == 3) {
            Preconditions.checkState((formatTokens[2].equals(DateTimeFieldSpec.TimeFormat.EPOCH.toString()) || formatTokens[2].equals(DateTimeFieldSpec.TimeFormat.TIMESTAMP.toString()) ? 1 : 0) != 0, (String)"Incorrect format type: %s in format: %s. Must be of '[0-9]+:<TimeUnit>:EPOCH|TIMESTAMP'", (Object)formatTokens[2], (Object)format);
        } else {
            Preconditions.checkState((boolean)formatTokens[2].equals(DateTimeFieldSpec.TimeFormat.SIMPLE_DATE_FORMAT.toString()), (String)"Incorrect format type: %s in format: %s. Must be of '[0-9]+:<TimeUnit>:SIMPLE_DATE_FORMAT:pattern'", (Object)formatTokens[2], (Object)format);
        }
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        DateTimeFormatSpec that = (DateTimeFormatSpec)o;
        return EqualityUtils.isEqual(this._size, that._size) && EqualityUtils.isEqual(this._format, that._format) && EqualityUtils.isEqual(this._unitSpec, that._unitSpec) && EqualityUtils.isEqual(this._patternSpec, that._patternSpec);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this._format);
        result = EqualityUtils.hashCodeOf(result, this._size);
        result = EqualityUtils.hashCodeOf(result, this._unitSpec);
        result = EqualityUtils.hashCodeOf(result, this._patternSpec);
        return result;
    }

    public String toString() {
        return "DateTimeFormatSpec{_format='" + this._format + '\'' + ", _size=" + this._size + ", _unitSpec=" + this._unitSpec + ", _patternSpec=" + this._patternSpec + '}';
    }
}

