/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.EnumUtils;
import org.apache.pinot.spi.utils.EqualityUtils;
import org.joda.time.Chronology;
import org.joda.time.DurationFieldType;
import org.joda.time.chrono.ISOChronology;

public class DateTimeFormatUnitSpec {
    private TimeUnit _timeUnit = null;
    private DateTimeTransformUnit _dateTimeTransformUnit = null;

    public DateTimeFormatUnitSpec(String unit) {
        DateTimeFormatUnitSpec.validateUnitSpec(unit);
        if (EnumUtils.isValidEnum(TimeUnit.class, (String)unit)) {
            this._timeUnit = TimeUnit.valueOf(unit);
        }
        if (EnumUtils.isValidEnum(DateTimeTransformUnit.class, (String)unit)) {
            this._dateTimeTransformUnit = DateTimeTransformUnit.valueOf(unit);
        }
    }

    public TimeUnit getTimeUnit() {
        return this._timeUnit;
    }

    public DateTimeTransformUnit getDateTimeTransformUnit() {
        return this._dateTimeTransformUnit;
    }

    public static void validateUnitSpec(String unit) {
        Preconditions.checkState((EnumUtils.isValidEnum(TimeUnit.class, (String)unit) || EnumUtils.isValidEnum(DateTimeTransformUnit.class, (String)unit) ? 1 : 0) != 0, (String)"Unit: %s must belong to enum TimeUnit or DateTimeTransformUnit", (Object)unit);
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        DateTimeFormatUnitSpec that = (DateTimeFormatUnitSpec)o;
        return EqualityUtils.isEqual((Object)this._timeUnit, (Object)that._timeUnit) && EqualityUtils.isEqual((Object)this._dateTimeTransformUnit, (Object)that._dateTimeTransformUnit);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf((Object)this._timeUnit);
        result = EqualityUtils.hashCodeOf(result, (Object)this._dateTimeTransformUnit);
        return result;
    }

    public static enum DateTimeTransformUnit {
        MILLISECONDS{

            @Override
            public long fromMillis(long millisSinceEpoch) {
                return millisSinceEpoch;
            }
        }
        ,
        SECONDS{

            @Override
            public long fromMillis(long millisSinceEpoch) {
                return TimeUnit.MILLISECONDS.toSeconds(millisSinceEpoch);
            }
        }
        ,
        MINUTES{

            @Override
            public long fromMillis(long millisSinceEpoch) {
                return TimeUnit.MILLISECONDS.toMinutes(millisSinceEpoch);
            }
        }
        ,
        HOURS{

            @Override
            public long fromMillis(long millisSinceEpoch) {
                return TimeUnit.MILLISECONDS.toHours(millisSinceEpoch);
            }
        }
        ,
        DAYS{

            @Override
            public long fromMillis(long millisSinceEpoch) {
                return TimeUnit.MILLISECONDS.toDays(millisSinceEpoch);
            }
        }
        ,
        WEEKS{

            @Override
            public long fromMillis(long millisSinceEpoch) {
                return DurationFieldType.weeks().getField((Chronology)ISOChronology.getInstanceUTC()).getDifference(millisSinceEpoch, 0L);
            }
        }
        ,
        MONTHS{

            @Override
            public long fromMillis(long millisSinceEpoch) {
                return DurationFieldType.months().getField((Chronology)ISOChronology.getInstanceUTC()).getDifference(millisSinceEpoch, 0L);
            }
        }
        ,
        YEARS{

            @Override
            public long fromMillis(long millisSinceEpoch) {
                return DurationFieldType.years().getField((Chronology)ISOChronology.getInstanceUTC()).getDifference(millisSinceEpoch, 0L);
            }
        };


        public abstract long fromMillis(long var1);
    }
}

