/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import java.math.BigDecimal;
import java.math.BigInteger;

public class BigDecimalUtils {
    private BigDecimalUtils() {
    }

    public static int byteSize(BigDecimal value) {
        BigInteger unscaledValue = value.unscaledValue();
        return (unscaledValue.bitLength() >>> 3) + 3;
    }

    public static byte[] serialize(BigDecimal value) {
        int scale = value.scale();
        BigInteger unscaledValue = value.unscaledValue();
        byte[] unscaledValueBytes = unscaledValue.toByteArray();
        byte[] valueBytes = new byte[unscaledValueBytes.length + 2];
        valueBytes[0] = (byte)(scale >>> 8);
        valueBytes[1] = (byte)scale;
        System.arraycopy(unscaledValueBytes, 0, valueBytes, 2, unscaledValueBytes.length);
        return valueBytes;
    }

    public static BigDecimal deserialize(byte[] bytes) {
        int scale = (bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF;
        byte[] unscaledValueBytes = new byte[bytes.length - 2];
        System.arraycopy(bytes, 2, unscaledValueBytes, 0, unscaledValueBytes.length);
        BigInteger unscaledValue = new BigInteger(unscaledValueBytes);
        return new BigDecimal(unscaledValue, scale);
    }
}

