/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import java.io.File;

public class CommonConstants {
    public static final String ENVIRONMENT_IDENTIFIER = "environment";
    public static final String INSTANCE_FAILURE_DOMAIN = "failureDomain";
    public static final String DEFAULT_FAILURE_DOMAIN = "No such domain";
    public static final String PREFIX_OF_SSL_SUBSET = "ssl";
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    public static final String KEY_OF_AUTH_TOKEN = "auth.token";
    public static final String TABLE_NAME = "tableName";
    public static final String CONFIG_OF_METRICS_FACTORY_CLASS_NAME = "factory.className";
    public static final String DEFAULT_METRICS_FACTORY_CLASS_NAME = "org.apache.pinot.plugin.metrics.yammer.YammerMetricsFactory";

    private CommonConstants() {
    }

    public static class Query {

        public static class Range {
            public static final char DELIMITER = '\u0000';
            public static final char LOWER_EXCLUSIVE = '(';
            public static final char LOWER_INCLUSIVE = '[';
            public static final char UPPER_EXCLUSIVE = ')';
            public static final char UPPER_INCLUSIVE = ']';
            public static final String UNBOUNDED = "*";
            public static final String LOWER_UNBOUNDED = "(*\u0000";
            public static final String UPPER_UNBOUNDED = "\u0000*)";
        }

        public static class Response {

            public static class ResponseType {
                public static final String DATA = "data";
                public static final String METADATA = "metadata";
                public static final String NON_STREAMING = "nonStreaming";
            }

            public static class MetadataKeys {
                public static final String RESPONSE_TYPE = "responseType";
            }
        }

        public static class Request {

            public static class PayloadType {
                public static final String SQL = "sql";
                public static final String BROKER_REQUEST = "brokerRequest";
            }

            public static class MetadataKeys {
                public static final String REQUEST_ID = "requestId";
                public static final String BROKER_ID = "brokerId";
                public static final String ENABLE_TRACE = "enableTrace";
                public static final String ENABLE_STREAMING = "enableStreaming";
                public static final String PAYLOAD_TYPE = "payloadType";
                public static final String EXPLAIN = "explain";
            }
        }
    }

    public static class Segment {
        public static final String START_TIME = "segment.start.time";
        public static final String END_TIME = "segment.end.time";
        public static final String TIME_UNIT = "segment.time.unit";
        public static final String INDEX_VERSION = "segment.index.version";
        public static final String TOTAL_DOCS = "segment.total.docs";
        public static final String CRC = "segment.crc";
        public static final String CREATION_TIME = "segment.creation.time";
        public static final String PUSH_TIME = "segment.push.time";
        public static final String REFRESH_TIME = "segment.refresh.time";
        public static final String DOWNLOAD_URL = "segment.download.url";
        public static final String CRYPTER_NAME = "segment.crypter";
        public static final String PARTITION_METADATA = "segment.partition.metadata";
        public static final String CUSTOM_MAP = "custom.map";
        public static final String SEGMENT_UPLOAD_START_TIME = "segment.upload.start.time";
        public static final String SEGMENT_BACKUP_DIR_SUFFIX = ".segment.bak";
        public static final String SEGMENT_TEMP_DIR_SUFFIX = ".segment.tmp";
        public static final String LOCAL_SEGMENT_SCHEME = "file";
        public static final String PEER_SEGMENT_DOWNLOAD_SCHEME = "peer://";
        public static final String METADATA_URI_FOR_PEER_DOWNLOAD = "";

        public static class BuiltInVirtualColumn {
            public static final String DOCID = "$docId";
            public static final String HOSTNAME = "$hostName";
            public static final String SEGMENTNAME = "$segmentName";
        }

        public static class AssignmentStrategy {
            public static final String BALANCE_NUM_SEGMENT_ASSIGNMENT_STRATEGY = "BalanceNumSegmentAssignmentStrategy";
            public static final String REPLICA_GROUP_SEGMENT_ASSIGNMENT_STRATEGY = "ReplicaGroupSegmentAssignmentStrategy";
        }

        @Deprecated
        public static class Offline {
            public static final String DOWNLOAD_URL = "segment.offline.download.url";
            public static final String PUSH_TIME = "segment.offline.push.time";
            public static final String REFRESH_TIME = "segment.offline.refresh.time";
        }

        public static class Realtime {
            public static final String STATUS = "segment.realtime.status";
            public static final String START_OFFSET = "segment.realtime.startOffset";
            public static final String END_OFFSET = "segment.realtime.endOffset";
            public static final String NUM_REPLICAS = "segment.realtime.numReplicas";
            public static final String FLUSH_THRESHOLD_SIZE = "segment.flush.threshold.size";
            public static final String FLUSH_THRESHOLD_TIME = "segment.flush.threshold.time";
            @Deprecated
            public static final String DOWNLOAD_URL = "segment.realtime.download.url";

            public static enum CompletionMode {
                DEFAULT,
                DOWNLOAD;

            }

            public static enum Status {
                IN_PROGRESS,
                DONE,
                UPLOADED;

            }
        }
    }

    public static class Minion {
        public static final String CONFIG_OF_METRICS_PREFIX = "pinot.minion.";
        public static final String METADATA_EVENT_OBSERVER_PREFIX = "metadata.event.notifier";
        public static final String CONFIG_OF_METRICS_PREFIX_KEY = "pinot.minion.metrics.prefix";
        @Deprecated
        public static final String DEPRECATED_CONFIG_OF_METRICS_PREFIX_KEY = "metricsPrefix";
        public static final String METRICS_REGISTRY_REGISTRATION_LISTENERS_KEY = "metricsRegistryRegistrationListeners";
        public static final String METRICS_CONFIG_PREFIX = "pinot.minion.metrics";
        public static final int DEFAULT_HELIX_PORT = 9514;
        public static final String DEFAULT_INSTANCE_BASE_DIR = System.getProperty("java.io.tmpdir") + File.separator + "PinotMinion";
        public static final String DEFAULT_INSTANCE_DATA_DIR = DEFAULT_INSTANCE_BASE_DIR + File.separator + "data";
        public static final String PREFIX_OF_CONFIG_OF_PINOT_FS_FACTORY = "pinot.minion.storage.factory";
        public static final String PREFIX_OF_CONFIG_OF_SEGMENT_FETCHER_FACTORY = "pinot.minion.segment.fetcher";
        public static final String PREFIX_OF_CONFIG_OF_SEGMENT_UPLOADER = "pinot.minion.segment.uploader";
        public static final String PREFIX_OF_CONFIG_OF_PINOT_CRYPTER = "pinot.minion.crypter";
        @Deprecated
        public static final String DEPRECATED_PREFIX_OF_CONFIG_OF_PINOT_FS_FACTORY = "storage.factory";
        @Deprecated
        public static final String DEPRECATED_PREFIX_OF_CONFIG_OF_SEGMENT_FETCHER_FACTORY = "segment.fetcher";
        @Deprecated
        public static final String DEPRECATED_PREFIX_OF_CONFIG_OF_SEGMENT_UPLOADER = "segment.uploader";
        @Deprecated
        public static final String DEPRECATED_PREFIX_OF_CONFIG_OF_PINOT_CRYPTER = "crypter";
        public static final String CONFIG_OF_TASK_AUTH_TOKEN = "task.auth.token";
        public static final String CONFIG_OF_ADMIN_API_PORT = "pinot.minion.adminapi.port";
        public static final String MINION_TLS_PREFIX = "pinot.minion.tls";
        public static final int DEFAULT_ADMIN_API_PORT = 6500;
        public static final String CONFIG_OF_MINION_QUERY_REWRITER_CLASS_NAMES = "pinot.minion.query.rewriter.class.names";
    }

    public static class Controller {
        public static final String PREFIX_OF_CONFIG_OF_SEGMENT_FETCHER_FACTORY = "pinot.controller.segment.fetcher";
        public static final String PREFIX_OF_CONFIG_OF_PINOT_FS_FACTORY = "pinot.controller.storage.factory";
        public static final String HOST_HTTP_HEADER = "Pinot-Controller-Host";
        public static final String VERSION_HTTP_HEADER = "Pinot-Controller-Version";
        public static final String SEGMENT_NAME_HTTP_HEADER = "Pinot-Segment-Name";
        public static final String TABLE_NAME_HTTP_HEADER = "Pinot-Table-Name";
        public static final String INGESTION_DESCRIPTOR = "Pinot-Ingestion-Descriptor";
        public static final String PREFIX_OF_CONFIG_OF_PINOT_CRYPTER = "pinot.controller.crypter";
        public static final String CONFIG_OF_CONTROLLER_METRICS_PREFIX = "controller.metrics.prefix";
        public static final String DEFAULT_METRICS_PREFIX = "pinot.controller.";
        public static final String CONFIG_OF_INSTANCE_ID = "pinot.controller.instance.id";
        public static final String CONFIG_OF_CONTROLLER_QUERY_REWRITER_CLASS_NAMES = "pinot.controller.query.rewriter.class.names";
        public static final String CONTROLLER_SERVICE_AUTO_DISCOVERY = "pinot.controller.service.auto.discovery";
    }

    public static class Server {
        public static final String CONFIG_OF_INSTANCE_ID = "pinot.server.instance.id";
        public static final String CONFIG_OF_INSTANCE_DATA_DIR = "pinot.server.instance.dataDir";
        public static final String CONFIG_OF_CONSUMER_DIR = "pinot.server.instance.consumerDir";
        public static final String CONFIG_OF_INSTANCE_SEGMENT_TAR_DIR = "pinot.server.instance.segmentTarDir";
        public static final String CONFIG_OF_INSTANCE_READ_MODE = "pinot.server.instance.readMode";
        public static final String CONFIG_OF_INSTANCE_RELOAD_CONSUMING_SEGMENT = "pinot.server.instance.reload.consumingSegment";
        public static final String CONFIG_OF_INSTANCE_DATA_MANAGER_CLASS = "pinot.server.instance.data.manager.class";
        public static final String CONFIG_OF_QUERY_EXECUTOR_PRUNER_CLASS = "pinot.server.query.executor.pruner.class";
        public static final String CONFIG_OF_QUERY_EXECUTOR_TIMEOUT = "pinot.server.query.executor.timeout";
        public static final String CONFIG_OF_QUERY_EXECUTOR_CLASS = "pinot.server.query.executor.class";
        public static final String CONFIG_OF_SERVER_QUERY_REWRITER_CLASS_NAMES = "pinot.server.query.rewriter.class.names";
        public static final String CONFIG_OF_REQUEST_HANDLER_FACTORY_CLASS = "pinot.server.requestHandlerFactory.class";
        public static final String CONFIG_OF_NETTY_SERVER_ENABLED = "pinot.server.netty.enabled";
        public static final boolean DEFAULT_NETTY_SERVER_ENABLED = true;
        public static final String CONFIG_OF_NETTY_PORT = "pinot.server.netty.port";
        public static final String CONFIG_OF_ENABLE_GRPC_SERVER = "pinot.server.grpc.enable";
        public static final boolean DEFAULT_ENABLE_GRPC_SERVER = false;
        public static final String CONFIG_OF_GRPC_PORT = "pinot.server.grpc.port";
        public static final int DEFAULT_GRPC_PORT = 8090;
        public static final String CONFIG_OF_GRPCTLS_SERVER_ENABLED = "pinot.server.grpctls.enabled";
        public static final boolean DEFAULT_GRPCTLS_SERVER_ENABLED = false;
        public static final String CONFIG_OF_NETTYTLS_SERVER_ENABLED = "pinot.server.nettytls.enabled";
        public static final boolean DEFAULT_NETTYTLS_SERVER_ENABLED = false;
        public static final String CONFIG_OF_SWAGGER_SERVER_ENABLED = "pinot.server.swagger.enabled";
        public static final boolean DEFAULT_SWAGGER_SERVER_ENABLED = true;
        public static final String CONFIG_OF_ADMIN_API_PORT = "pinot.server.adminapi.port";
        public static final int DEFAULT_ADMIN_API_PORT = 8097;
        public static final String CONFIG_OF_SEGMENT_FORMAT_VERSION = "pinot.server.instance.segment.format.version";
        public static final String CONFIG_OF_ENABLE_SPLIT_COMMIT = "pinot.server.instance.enable.split.commit";
        public static final String CONFIG_OF_ENABLE_COMMIT_END_WITH_METADATA = "pinot.server.instance.enable.commitend.metadata";
        public static final String CONFIG_OF_REALTIME_OFFHEAP_ALLOCATION = "pinot.server.instance.realtime.alloc.offheap";
        public static final String CONFIG_OF_REALTIME_OFFHEAP_DIRECT_ALLOCATION = "pinot.server.instance.realtime.alloc.offheap.direct";
        public static final String PREFIX_OF_CONFIG_OF_PINOT_FS_FACTORY = "pinot.server.storage.factory";
        public static final String PREFIX_OF_CONFIG_OF_PINOT_CRYPTER = "pinot.server.crypter";
        public static final String CONFIG_OF_VALUE_PRUNER_IN_PREDICATE_THRESHOLD = "pinot.server.query.executor.pruner.columnvaluesegmentpruner.inpredicate.threshold";
        public static final int DEFAULT_VALUE_PRUNER_IN_PREDICATE_THRESHOLD = 10;
        public static final String CONFIG_OF_AUTH_TOKEN = "auth.token";
        public static final String CONFIG_OF_SERVER_MIN_RESOURCE_PERCENT_FOR_START = "pinot.server.startup.minResourcePercent";
        public static final double DEFAULT_SERVER_MIN_RESOURCE_PERCENT_FOR_START = 100.0;
        public static final String CONFIG_OF_STARTUP_REALTIME_CONSUMPTION_CATCHUP_WAIT_MS = "pinot.server.starter.realtimeConsumptionCatchupWaitMs";
        public static final int DEFAULT_STARTUP_REALTIME_CONSUMPTION_CATCHUP_WAIT_MS = 0;
        public static final String CONFIG_OF_ENABLE_REALTIME_OFFSET_BASED_CONSUMPTION_STATUS_CHECKER = "pinot.server.starter.enableRealtimeOffsetBasedConsumptionStatusChecker";
        public static final boolean DEFAULT_ENABLE_REALTIME_OFFSET_BASED_CONSUMPTION_STATUS_CHECKER = false;
        public static final String DEFAULT_READ_MODE = "mmap";
        public static final boolean DEFAULT_RELOAD_CONSUMING_SEGMENT = true;
        public static final String DEFAULT_INSTANCE_BASE_DIR = System.getProperty("java.io.tmpdir") + File.separator + "PinotServer";
        public static final String DEFAULT_INSTANCE_DATA_DIR = DEFAULT_INSTANCE_BASE_DIR + File.separator + "index";
        public static final String DEFAULT_INSTANCE_SEGMENT_TAR_DIR = DEFAULT_INSTANCE_BASE_DIR + File.separator + "segmentTar";
        public static final String DEFAULT_DATA_MANAGER_CLASS = "org.apache.pinot.server.starter.helix.HelixInstanceDataManager";
        public static final String DEFAULT_QUERY_EXECUTOR_CLASS = "org.apache.pinot.core.query.executor.ServerQueryExecutorV1Impl";
        public static final long DEFAULT_QUERY_EXECUTOR_TIMEOUT_MS = 15000L;
        public static final String DEFAULT_REQUEST_HANDLER_FACTORY_CLASS = "org.apache.pinot.server.request.SimpleRequestHandlerFactory";
        public static final String PREFIX_OF_CONFIG_OF_SEGMENT_FETCHER_FACTORY = "pinot.server.segment.fetcher";
        public static final String CONFIG_OF_STARTUP_TIMEOUT_MS = "pinot.server.startup.timeoutMs";
        public static final long DEFAULT_STARTUP_TIMEOUT_MS = 600000L;
        public static final String CONFIG_OF_STARTUP_ENABLE_SERVICE_STATUS_CHECK = "pinot.server.startup.enableServiceStatusCheck";
        public static final boolean DEFAULT_STARTUP_ENABLE_SERVICE_STATUS_CHECK = true;
        public static final String CONFIG_OF_STARTUP_SERVICE_STATUS_CHECK_INTERVAL_MS = "pinot.server.startup.serviceStatusCheckIntervalMs";
        public static final long DEFAULT_STARTUP_SERVICE_STATUS_CHECK_INTERVAL_MS = 10000L;
        public static final String CONFIG_OF_SHUTDOWN_TIMEOUT_MS = "pinot.server.shutdown.timeoutMs";
        public static final long DEFAULT_SHUTDOWN_TIMEOUT_MS = 600000L;
        public static final String CONFIG_OF_SHUTDOWN_ENABLE_QUERY_CHECK = "pinot.server.shutdown.enableQueryCheck";
        public static final boolean DEFAULT_SHUTDOWN_ENABLE_QUERY_CHECK = true;
        public static final String CONFIG_OF_SHUTDOWN_NO_QUERY_THRESHOLD_MS = "pinot.server.shutdown.noQueryThresholdMs";
        public static final String CONFIG_OF_SHUTDOWN_ENABLE_RESOURCE_CHECK = "pinot.server.shutdown.enableResourceCheck";
        public static final boolean DEFAULT_SHUTDOWN_ENABLE_RESOURCE_CHECK = false;
        public static final String CONFIG_OF_SHUTDOWN_RESOURCE_CHECK_INTERVAL_MS = "pinot.server.shutdown.resourceCheckIntervalMs";
        public static final long DEFAULT_SHUTDOWN_RESOURCE_CHECK_INTERVAL_MS = 10000L;
        public static final String DEFAULT_COLUMN_MIN_MAX_VALUE_GENERATOR_MODE = "ALL";
        public static final String PINOT_SERVER_METRICS_PREFIX = "pinot.server.metrics.prefix";
        public static final String SERVER_TLS_PREFIX = "pinot.server.tls";
        public static final String SERVER_NETTYTLS_PREFIX = "pinot.server.nettytls";
        public static final String SERVER_GRPCTLS_PREFIX = "pinot.server.grpctls";
        public static final String CONFIG_OF_SEGMENT_STORE_URI = "segment.store.uri";
        public static final String DEFAULT_METRICS_PREFIX = "pinot.server.";
        public static final String CONFIG_OF_ENABLE_TABLE_LEVEL_METRICS = "pinot.server.enableTableLevelMetrics";
        public static final boolean DEFAULT_ENABLE_TABLE_LEVEL_METRICS = true;
        public static final String CONFIG_OF_ALLOWED_TABLES_FOR_EMITTING_METRICS = "pinot.server.allowedTablesForEmittingMetrics";
        public static final String ACCESS_CONTROL_FACTORY_CLASS = "pinot.server.admin.access.control.factory.class";
        public static final String DEFAULT_ACCESS_CONTROL_FACTORY_CLASS = "org.apache.pinot.server.access.AllowAllAccessFactory";
        public static final String PREFIX_OF_CONFIG_OF_ACCESS_CONTROL = "pinot.server.admin.access.control";
        public static final String CONFIG_OF_ENABLE_THREAD_CPU_TIME_MEASUREMENT = "pinot.server.instance.enableThreadCpuTimeMeasurement";
        public static final boolean DEFAULT_ENABLE_THREAD_CPU_TIME_MEASUREMENT = false;
        public static final String CONFIG_OF_CURRENT_DATA_TABLE_VERSION = "pinot.server.instance.currentDataTableVersion";
        public static final int DEFAULT_CURRENT_DATA_TABLE_VERSION = 3;
        public static final String PREFIX_OF_CONFIG_OF_ENVIRONMENT_PROVIDER_FACTORY = "pinot.server.environmentProvider.factory";
        public static final String ENVIRONMENT_PROVIDER_CLASS_NAME = "pinot.server.environmentProvider.className";

        public static class SegmentCompletionProtocol {
            public static final String PREFIX_OF_CONFIG_OF_SEGMENT_UPLOADER = "pinot.server.segment.uploader";
            @Deprecated
            public static final String CONFIG_OF_CONTROLLER_HTTPS_ENABLED = "enabled";
            @Deprecated
            public static final String CONFIG_OF_CONTROLLER_HTTPS_PORT = "controller.port";
            public static final String CONFIG_OF_SEGMENT_UPLOAD_REQUEST_TIMEOUT_MS = "upload.request.timeout.ms";
            public static final String CONFIG_OF_PROTOCOL = "protocol";
            public static final String CONFIG_OF_SEGMENT_UPLOADER_AUTH_TOKEN = "auth.token";
            public static final int DEFAULT_SEGMENT_UPLOAD_REQUEST_TIMEOUT_MS = 300000;
            public static final int DEFAULT_OTHER_REQUESTS_TIMEOUT = 10000;
        }
    }

    public static class Broker {
        public static final String ROUTING_TABLE_CONFIG_PREFIX = "pinot.broker.routing.table";
        public static final String ACCESS_CONTROL_CONFIG_PREFIX = "pinot.broker.access.control";
        public static final String METRICS_CONFIG_PREFIX = "pinot.broker.metrics";
        public static final String CONFIG_OF_METRICS_NAME_PREFIX = "pinot.broker.metrics.prefix";
        public static final String DEFAULT_METRICS_NAME_PREFIX = "pinot.broker.";
        public static final String CONFIG_OF_DELAY_SHUTDOWN_TIME_MS = "pinot.broker.delayShutdownTimeMs";
        public static final long DEFAULT_DELAY_SHUTDOWN_TIME_MS = 10000L;
        public static final String CONFIG_OF_ENABLE_TABLE_LEVEL_METRICS = "pinot.broker.enableTableLevelMetrics";
        public static final boolean DEFAULT_ENABLE_TABLE_LEVEL_METRICS = true;
        public static final String CONFIG_OF_ALLOWED_TABLES_FOR_EMITTING_METRICS = "pinot.broker.allowedTablesForEmittingMetrics";
        public static final String CONFIG_OF_BROKER_QUERY_REWRITER_CLASS_NAMES = "pinot.broker.query.rewriter.class.names";
        public static final String CONFIG_OF_BROKER_QUERY_RESPONSE_LIMIT = "pinot.broker.query.response.limit";
        public static final int DEFAULT_BROKER_QUERY_RESPONSE_LIMIT = Integer.MAX_VALUE;
        public static final String CONFIG_OF_BROKER_QUERY_LOG_LENGTH = "pinot.broker.query.log.length";
        public static final int DEFAULT_BROKER_QUERY_LOG_LENGTH = Integer.MAX_VALUE;
        public static final String CONFIG_OF_BROKER_QUERY_LOG_MAX_RATE_PER_SECOND = "pinot.broker.query.log.maxRatePerSecond";
        public static final double DEFAULT_BROKER_QUERY_LOG_MAX_RATE_PER_SECOND = 10000.0;
        public static final String CONFIG_OF_BROKER_TIMEOUT_MS = "pinot.broker.timeoutMs";
        public static final long DEFAULT_BROKER_TIMEOUT_MS = 10000L;
        public static final String CONFIG_OF_BROKER_ID = "pinot.broker.id";
        public static final String CONFIG_OF_BROKER_HOSTNAME = "pinot.broker.hostname";
        public static final String CONFIG_OF_BROKER_MIN_RESOURCE_PERCENT_FOR_START = "pinot.broker.startup.minResourcePercent";
        public static final double DEFAULT_BROKER_MIN_RESOURCE_PERCENT_FOR_START = 100.0;
        public static final String CONFIG_OF_ENABLE_QUERY_LIMIT_OVERRIDE = "pinot.broker.enable.query.limit.override";
        public static final String CONFIG_OF_MAX_REDUCE_THREADS_PER_QUERY = "pinot.broker.max.reduce.threads.per.query";
        public static final int DEFAULT_MAX_REDUCE_THREADS_PER_QUERY = Math.max(1, Math.min(10, Runtime.getRuntime().availableProcessors() / 2));
        public static final String CONFIG_OF_BROKER_GROUPBY_TRIM_THRESHOLD = "pinot.broker.groupby.trim.threshold";
        public static final int DEFAULT_BROKER_GROUPBY_TRIM_THRESHOLD = 1000000;
        public static final String BROKER_REQUEST_HANDLER_TYPE = "pinot.broker.request.handler.type";
        public static final String NETTY_BROKER_REQUEST_HANDLER_TYPE = "netty";
        public static final String GRPC_BROKER_REQUEST_HANDLER_TYPE = "grpc";
        public static final String DEFAULT_BROKER_REQUEST_HANDLER_TYPE = "netty";
        public static final String BROKER_TLS_PREFIX = "pinot.broker.tls";
        public static final String BROKER_NETTYTLS_ENABLED = "pinot.broker.nettytls.enabled";
        public static final String BROKER_SERVICE_AUTO_DISCOVERY = "pinot.broker.service.auto.discovery";
        public static final String DISABLE_GROOVY = "pinot.broker.disable.query.groovy";

        public static class Request {
            public static final String PQL = "pql";
            public static final String SQL = "sql";
            public static final String TRACE = "trace";
            public static final String DEBUG_OPTIONS = "debugOptions";
            public static final String QUERY_OPTIONS = "queryOptions";

            public static class QueryOptionKey {
                public static final String TIMEOUT_MS = "timeoutMs";
                public static final String PRESERVE_TYPE = "preserveType";
                public static final String RESPONSE_FORMAT = "responseFormat";
                public static final String GROUP_BY_MODE = "groupByMode";
                public static final String SKIP_UPSERT = "skipUpsert";
                public static final String MAX_EXECUTION_THREADS = "maxExecutionThreads";
                public static final String MIN_SEGMENT_GROUP_TRIM_SIZE = "minSegmentGroupTrimSize";
                public static final String MIN_SERVER_GROUP_TRIM_SIZE = "minServerGroupTrimSize";
            }
        }
    }

    public static class Helix {
        public static final String IS_SHUTDOWN_IN_PROGRESS = "shutdownInProgress";
        public static final String QUERIES_DISABLED = "queriesDisabled";
        public static final String QUERY_RATE_LIMIT_DISABLED = "queryRateLimitDisabled";
        public static final String INSTANCE_CONNECTED_METRIC_NAME = "helix.connected";
        public static final String PREFIX_OF_CONTROLLER_INSTANCE = "Controller_";
        public static final String PREFIX_OF_BROKER_INSTANCE = "Broker_";
        public static final String PREFIX_OF_SERVER_INSTANCE = "Server_";
        public static final String PREFIX_OF_MINION_INSTANCE = "Minion_";
        public static final int CONTROLLER_INSTANCE_PREFIX_LENGTH = "Controller_".length();
        public static final int BROKER_INSTANCE_PREFIX_LENGTH = "Broker_".length();
        public static final int SERVER_INSTANCE_PREFIX_LENGTH = "Server_".length();
        public static final int MINION_INSTANCE_PREFIX_LENGTH = "Minion_".length();
        public static final String BROKER_RESOURCE_INSTANCE = "brokerResource";
        public static final String LEAD_CONTROLLER_RESOURCE_NAME = "leadControllerResource";
        public static final String LEAD_CONTROLLER_RESOURCE_ENABLED_KEY = "RESOURCE_ENABLED";
        public static final String ENABLE_CASE_INSENSITIVE_KEY = "enable.case.insensitive";
        @Deprecated
        public static final String DEPRECATED_ENABLE_CASE_INSENSITIVE_KEY = "enable.case.insensitive.pql";
        public static final String DEFAULT_HYPERLOGLOG_LOG2M_KEY = "default.hyperloglog.log2m";
        public static final int DEFAULT_HYPERLOGLOG_LOG2M = 8;
        public static final String ENABLE_DISTINCT_COUNT_BITMAP_OVERRIDE_KEY = "enable.distinct.count.bitmap.override";
        public static final int NUMBER_OF_PARTITIONS_IN_LEAD_CONTROLLER_RESOURCE = 24;
        public static final int LEAD_CONTROLLER_RESOURCE_REPLICA_COUNT = 1;
        public static final int MIN_ACTIVE_REPLICAS = 0;
        public static final int REBALANCE_DELAY_MS = 300000;
        public static final String CONTROLLER_INSTANCE = "controller";
        public static final String UNTAGGED_BROKER_INSTANCE = "broker_untagged";
        public static final String UNTAGGED_SERVER_INSTANCE = "server_untagged";
        public static final String UNTAGGED_MINION_INSTANCE = "minion_untagged";
        public static final String SET_INSTANCE_ID_TO_HOSTNAME_KEY = "pinot.set.instance.id.to.hostname";
        public static final String KEY_OF_SERVER_NETTY_PORT = "pinot.server.netty.port";
        public static final int DEFAULT_SERVER_NETTY_PORT = 8098;
        public static final String KEY_OF_SERVER_NETTYTLS_PORT = "pinot.server.nettytls.port";
        public static final int DEFAULT_SERVER_NETTYTLS_PORT = 8091;
        public static final String KEY_OF_BROKER_QUERY_PORT = "pinot.broker.client.queryPort";
        public static final int DEFAULT_BROKER_QUERY_PORT = 8099;
        public static final String KEY_OF_SERVER_NETTY_HOST = "pinot.server.netty.host";
        public static final String KEY_OF_MINION_HOST = "pinot.minion.host";
        public static final String KEY_OF_MINION_PORT = "pinot.minion.port";
        public static final String CONFIG_OF_CONTROLLER_FLAPPING_TIME_WINDOW_MS = "pinot.controller.flapping.timeWindowMs";
        public static final String CONFIG_OF_BROKER_FLAPPING_TIME_WINDOW_MS = "pinot.broker.flapping.timeWindowMs";
        public static final String CONFIG_OF_SERVER_FLAPPING_TIME_WINDOW_MS = "pinot.server.flapping.timeWindowMs";
        public static final String CONFIG_OF_MINION_FLAPPING_TIME_WINDOW_MS = "pinot.minion.flapping.timeWindowMs";
        public static final String CONFIG_OF_HELIX_INSTANCE_MAX_STATE_TRANSITIONS = "pinot.helix.instance.state.maxStateTransitions";
        public static final String DEFAULT_HELIX_INSTANCE_MAX_STATE_TRANSITIONS = "100000";
        public static final String DEFAULT_FLAPPING_TIME_WINDOW_MS = "1";
        public static final String PINOT_SERVICE_ROLE = "pinot.service.role";
        public static final String CONFIG_OF_CLUSTER_NAME = "pinot.cluster.name";
        public static final String CONFIG_OF_ZOOKEEPR_SERVER = "pinot.zk.server";
        public static final String CONFIG_OF_PINOT_CONTROLLER_STARTABLE_CLASS = "pinot.controller.startable.class";
        public static final String CONFIG_OF_PINOT_BROKER_STARTABLE_CLASS = "pinot.broker.startable.class";
        public static final String CONFIG_OF_PINOT_SERVER_STARTABLE_CLASS = "pinot.server.startable.class";
        public static final String CONFIG_OF_PINOT_MINION_STARTABLE_CLASS = "pinot.minion.startable.class";

        public static class Instance {
            public static final String INSTANCE_ID_KEY = "instanceId";
            public static final String DATA_DIR_KEY = "dataDir";
            public static final String ADMIN_PORT_KEY = "adminPort";
            public static final String ADMIN_HTTPS_PORT_KEY = "adminHttpsPort";
            public static final String GRPC_PORT_KEY = "grpcPort";
            public static final String NETTYTLS_PORT_KEY = "nettyTlsPort";
            public static final String SYSTEM_RESOURCE_INFO_KEY = "SYSTEM_RESOURCE_INFO";
        }

        public static class DataSource {

            public static enum SegmentAssignmentStrategyType {
                RandomAssignmentStrategy,
                BalanceNumSegmentAssignmentStrategy,
                BucketizedSegmentAssignmentStrategy,
                ReplicaGroupSegmentAssignmentStrategy;

            }
        }

        public static class ZkClient {
            public static final long DEFAULT_CONNECT_TIMEOUT_SEC = 60L;
            public static final int RETRY_INTERVAL_MS = 50;
            public static final int RETRY_COUNT = 2;
        }

        public static class StateModel {

            public static class BrokerResourceStateModel {
                public static final String ONLINE = "ONLINE";
                public static final String OFFLINE = "OFFLINE";
                public static final String ERROR = "ERROR";
            }

            public static class SegmentStateModel {
                public static final String ONLINE = "ONLINE";
                public static final String OFFLINE = "OFFLINE";
                public static final String ERROR = "ERROR";
                public static final String CONSUMING = "CONSUMING";
            }
        }
    }

    public static class Table {
        public static final String PUSH_FREQUENCY_HOURLY = "hourly";
        public static final String PUSH_FREQUENCY_DAILY = "daily";
        public static final String PUSH_FREQUENCY_WEEKLY = "weekly";
        public static final String PUSH_FREQUENCY_MONTHLY = "monthly";
    }

    public static enum ConsumerState {
        CONSUMING,
        NOT_CONSUMING;

    }
}

