/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils.retry;

import java.util.concurrent.Callable;
import org.apache.pinot.spi.utils.retry.AttemptsExceededException;
import org.apache.pinot.spi.utils.retry.RetriableOperationException;
import org.apache.pinot.spi.utils.retry.RetryPolicy;

public abstract class BaseRetryPolicy
implements RetryPolicy {
    private final int _maxNumAttempts;

    protected BaseRetryPolicy(int maxNumAttempts) {
        this._maxNumAttempts = maxNumAttempts;
    }

    protected abstract long getDelayMs(int var1);

    @Override
    public void attempt(Callable<Boolean> operation) throws AttemptsExceededException, RetriableOperationException {
        int attempt = 0;
        while (attempt < this._maxNumAttempts) {
            try {
                if (Boolean.TRUE.equals(operation.call())) {
                    return;
                }
                Thread.sleep(this.getDelayMs(attempt++));
            }
            catch (Exception e) {
                throw new RetriableOperationException(e);
            }
        }
        throw new AttemptsExceededException("Operation failed after " + this._maxNumAttempts + " attempts");
    }
}

