/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.spi.ColumnHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class SplitContext {
    public static final SplitContext NON_CACHEABLE = new SplitContext(false);
    private final boolean cacheable;
    private final Optional<TupleDomain<ColumnHandle>> dynamicFilterPredicate;

    @JsonCreator
    public SplitContext(@JsonProperty boolean cacheable) {
        this(cacheable, Optional.empty());
    }

    public SplitContext(boolean cacheable, TupleDomain<ColumnHandle> dynamicFilterPredicate) {
        this(cacheable, Optional.of(Objects.requireNonNull(dynamicFilterPredicate, "dynamicFilterPredicate is null")));
    }

    private SplitContext(boolean cacheable, Optional<TupleDomain<ColumnHandle>> dynamicFilterPredicate) {
        this.cacheable = cacheable;
        this.dynamicFilterPredicate = dynamicFilterPredicate;
    }

    @JsonProperty
    public boolean isCacheable() {
        return this.cacheable;
    }

    public Optional<TupleDomain<ColumnHandle>> getDynamicFilterPredicate() {
        return this.dynamicFilterPredicate;
    }
}

