/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MarkDistinctNode
extends PlanNode {
    private final PlanNode source;
    private final VariableReferenceExpression markerVariable;
    private final Optional<VariableReferenceExpression> hashVariable;
    private final List<VariableReferenceExpression> distinctVariables;
    private final List<VariableReferenceExpression> output;

    @JsonCreator
    public MarkDistinctNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="markerVariable") VariableReferenceExpression markerVariable, @JsonProperty(value="distinctVariables") List<VariableReferenceExpression> distinctVariables, @JsonProperty(value="hashVariable") Optional<VariableReferenceExpression> hashVariable) {
        super(sourceLocation, id);
        this.source = source;
        this.markerVariable = markerVariable;
        this.hashVariable = Objects.requireNonNull(hashVariable, "hashVariable is null");
        Objects.requireNonNull(distinctVariables, "distinctVariables is null");
        MarkDistinctNode.checkArgument(!distinctVariables.isEmpty(), "distinctVariables cannot be empty");
        this.distinctVariables = Collections.unmodifiableList(new ArrayList<VariableReferenceExpression>(distinctVariables));
        ArrayList<VariableReferenceExpression> variableReferenceExpressions = new ArrayList<VariableReferenceExpression>(source.getOutputVariables());
        variableReferenceExpressions.add(markerVariable);
        this.output = Collections.unmodifiableList(variableReferenceExpressions);
    }

    @Override
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.output;
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.unmodifiableList(Collections.singletonList(this.source));
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public VariableReferenceExpression getMarkerVariable() {
        return this.markerVariable;
    }

    @JsonProperty
    public List<VariableReferenceExpression> getDistinctVariables() {
        return this.distinctVariables;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getHashVariable() {
        return this.hashVariable;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitMarkDistinct(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        MarkDistinctNode.checkArgument(newChildren.size() == 1, "Unexpected number of elements in list newChildren");
        return new MarkDistinctNode(this.getSourceLocation(), this.getId(), newChildren.get(0), this.markerVariable, this.distinctVariables, this.hashVariable);
    }

    private static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }
}

