/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.file;

import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.AccessCondition;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.DoesServiceRequest;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.OperationContext;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.core.Base64;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.file.CloudFile;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.file.FileRequestOptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class FileOutputStream
extends OutputStream {
    private final CloudFile parentFileRef;
    volatile boolean streamFaulted;
    Object lastErrorLock = new Object();
    IOException lastError;
    OperationContext opContext;
    FileRequestOptions options;
    private MessageDigest md5Digest;
    private long currentOffset;
    private ByteArrayOutputStream outBuffer;
    private int currentBufferedBytes;
    private int internalWriteThreshold = -1;
    private volatile int outstandingRequests;
    private final ExecutorService threadExecutor;
    private final ExecutorCompletionService<Void> completionService;
    AccessCondition accessCondition = null;

    @DoesServiceRequest
    protected FileOutputStream(CloudFile parentFile, long length, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        this.accessCondition = accessCondition;
        this.parentFileRef = parentFile;
        this.options = new FileRequestOptions(options);
        this.outBuffer = new ByteArrayOutputStream();
        this.opContext = opContext;
        this.streamFaulted = false;
        if (this.options.getConcurrentRequestCount() < 1) {
            throw new IllegalArgumentException("ConcurrentRequestCount");
        }
        if (this.options.getStoreFileContentMD5().booleanValue()) {
            try {
                this.md5Digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw Utility.generateNewUnexpectedStorageException(e);
            }
        }
        this.threadExecutor = Executors.newFixedThreadPool(this.options.getConcurrentRequestCount());
        this.completionService = new ExecutorCompletionService(this.threadExecutor);
        this.internalWriteThreshold = (int)Math.min((long)this.parentFileRef.getStreamWriteSizeInBytes(), length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStreamState() throws IOException {
        Object object = this.lastErrorLock;
        synchronized (object) {
            if (this.streamFaulted) {
                throw this.lastError;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @DoesServiceRequest
    public void close() throws IOException {
        try {
            this.checkStreamState();
            this.flush();
            this.threadExecutor.shutdown();
            while (this.outstandingRequests > 0) {
                this.waitForTaskToComplete();
            }
            this.checkStreamState();
            try {
                this.commit();
            }
            catch (StorageException e) {
                throw Utility.initIOException(e);
            }
        }
        finally {
            Object object = this.lastErrorLock;
            synchronized (object) {
                this.streamFaulted = true;
                this.lastError = new IOException("Stream is already closed.");
            }
            if (!this.threadExecutor.isShutdown()) {
                this.threadExecutor.shutdownNow();
            }
        }
    }

    @DoesServiceRequest
    private void commit() throws StorageException {
        if (this.options.getStoreFileContentMD5().booleanValue()) {
            this.parentFileRef.getProperties().setContentMD5(Base64.encode(this.md5Digest.digest()));
        }
        this.parentFileRef.uploadProperties(this.accessCondition, this.options, this.opContext);
    }

    @DoesServiceRequest
    private synchronized void dispatchWrite(int writeLength) throws IOException {
        long tempLength;
        if (writeLength == 0) {
            return;
        }
        Callable<Void> worker = null;
        if (this.outstandingRequests > this.options.getConcurrentRequestCount() * 2) {
            this.waitForTaskToComplete();
        }
        final ByteArrayInputStream bufferRef = new ByteArrayInputStream(this.outBuffer.toByteArray());
        final CloudFile fileRef = this.parentFileRef;
        long tempOffset = this.currentOffset;
        final long opWriteLength = tempLength = (long)writeLength;
        final long opOffset = tempOffset;
        this.currentOffset += (long)writeLength;
        worker = new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() {
                try {
                    fileRef.uploadRange(bufferRef, opOffset, opWriteLength, FileOutputStream.this.accessCondition, FileOutputStream.this.options, FileOutputStream.this.opContext);
                }
                catch (IOException e) {
                    Object object = FileOutputStream.this.lastErrorLock;
                    synchronized (object) {
                        FileOutputStream.this.streamFaulted = true;
                        FileOutputStream.this.lastError = e;
                    }
                }
                catch (StorageException e) {
                    Object object = FileOutputStream.this.lastErrorLock;
                    synchronized (object) {
                        FileOutputStream.this.streamFaulted = true;
                        FileOutputStream.this.lastError = Utility.initIOException(e);
                    }
                }
                return null;
            }
        };
        this.completionService.submit(worker);
        ++this.outstandingRequests;
        this.currentBufferedBytes = 0;
        this.outBuffer = new ByteArrayOutputStream();
    }

    @Override
    @DoesServiceRequest
    public synchronized void flush() throws IOException {
        this.checkStreamState();
        this.dispatchWrite(this.currentBufferedBytes);
    }

    private void waitForTaskToComplete() throws IOException {
        try {
            Future<Void> future = this.completionService.take();
            future.get();
        }
        catch (InterruptedException e) {
            throw Utility.initIOException(e);
        }
        catch (ExecutionException e) {
            throw Utility.initIOException(e);
        }
        --this.outstandingRequests;
    }

    @Override
    @DoesServiceRequest
    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    @Override
    @DoesServiceRequest
    public void write(byte[] data, int offset, int length) throws IOException {
        if (offset < 0 || length < 0 || length > data.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        this.writeInternal(data, offset, length);
    }

    @DoesServiceRequest
    public void write(InputStream sourceStream, long writeLength) throws IOException, StorageException {
        Utility.writeToOutputStream(sourceStream, this, writeLength, false, false, this.opContext, this.options);
    }

    @Override
    @DoesServiceRequest
    public void write(int byteVal) throws IOException {
        this.write(new byte[]{(byte)(byteVal & 0xFF)});
    }

    @DoesServiceRequest
    private synchronized void writeInternal(byte[] data, int offset, int length) throws IOException {
        while (length > 0) {
            this.checkStreamState();
            int availableBufferBytes = this.internalWriteThreshold - this.currentBufferedBytes;
            int nextWrite = Math.min(availableBufferBytes, length);
            if (this.options.getStoreFileContentMD5().booleanValue()) {
                this.md5Digest.update(data, offset, nextWrite);
            }
            this.outBuffer.write(data, offset, nextWrite);
            this.currentBufferedBytes += nextWrite;
            offset += nextWrite;
            length -= nextWrite;
            if (this.currentBufferedBytes != this.internalWriteThreshold) continue;
            this.dispatchWrite(this.internalWriteThreshold);
        }
    }
}

