/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.blackhole;

import com.facebook.presto.plugin.blackhole.BlackHoleColumnHandle;
import com.facebook.presto.plugin.blackhole.BlackHoleInsertTableHandle;
import com.facebook.presto.plugin.blackhole.BlackHoleOutputTableHandle;
import com.facebook.presto.plugin.blackhole.BlackHolePartitioningHandle;
import com.facebook.presto.plugin.blackhole.BlackHoleTableHandle;
import com.facebook.presto.plugin.blackhole.BlackHoleTableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorOutputMetadata;
import com.facebook.presto.spi.connector.ConnectorPartitioningHandle;
import com.facebook.presto.spi.statistics.ComputedStatistics;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.slice.Slice;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class BlackHoleMetadata
implements ConnectorMetadata {
    public static final String SCHEMA_NAME = "default";
    private final List<String> schemas = new ArrayList<String>();
    private final Map<SchemaTableName, BlackHoleTableHandle> tables = new ConcurrentHashMap<SchemaTableName, BlackHoleTableHandle>();

    public BlackHoleMetadata() {
        this.schemas.add(SCHEMA_NAME);
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.copyOf(this.schemas);
    }

    public synchronized void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties) {
        if (this.schemas.contains(schemaName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("Schema [%s] already exists", schemaName));
        }
        this.schemas.add(schemaName);
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        return this.tables.get(tableName);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        BlackHoleTableHandle blackHoleTableHandle = (BlackHoleTableHandle)tableHandle;
        return blackHoleTableHandle.toTableMetadata();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        return this.tables.values().stream().filter(table -> schemaNameOrNull == null || table.getSchemaName().equals(schemaNameOrNull)).map(BlackHoleTableHandle::toSchemaTableName).collect(Collectors.toList());
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        BlackHoleTableHandle blackHoleTableHandle = (BlackHoleTableHandle)tableHandle;
        return blackHoleTableHandle.getColumnHandles().stream().collect(Collectors.toMap(BlackHoleColumnHandle::getName, column -> column));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        BlackHoleColumnHandle blackHoleColumnHandle = (BlackHoleColumnHandle)columnHandle;
        return blackHoleColumnHandle.toColumnMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        return this.tables.values().stream().filter(table -> prefix.matches(table.toSchemaTableName())).collect(Collectors.toMap(BlackHoleTableHandle::toSchemaTableName, handle -> handle.toTableMetadata().getColumns()));
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        BlackHoleTableHandle blackHoleTableHandle = (BlackHoleTableHandle)tableHandle;
        this.tables.remove(blackHoleTableHandle.toSchemaTableName());
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        BlackHoleTableHandle oldTableHandle = (BlackHoleTableHandle)tableHandle;
        BlackHoleTableHandle newTableHandle = new BlackHoleTableHandle(oldTableHandle.getSchemaName(), newTableName.getTableName(), oldTableHandle.getColumnHandles(), oldTableHandle.getSplitCount(), oldTableHandle.getPagesPerSplit(), oldTableHandle.getRowsPerPage(), oldTableHandle.getFieldsLength(), oldTableHandle.getPageProcessingDelay());
        this.tables.remove(oldTableHandle.toSchemaTableName());
        this.tables.put(newTableName, newTableHandle);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        ConnectorOutputTableHandle outputTableHandle = this.beginCreateTable(session, tableMetadata, Optional.empty());
        this.finishCreateTable(session, outputTableHandle, (Collection<Slice>)ImmutableList.of(), (Collection<ComputedStatistics>)ImmutableList.of());
    }

    public Optional<ConnectorNewTableLayout> getNewTableLayout(ConnectorSession connectorSession, ConnectorTableMetadata tableMetadata) {
        List distributeColumns = (List)tableMetadata.getProperties().get("distributed_on");
        if (distributeColumns.isEmpty()) {
            return Optional.empty();
        }
        Sets.SetView undefinedColumns = Sets.difference((Set)ImmutableSet.copyOf((Collection)distributeColumns), tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(Collectors.toSet()));
        if (!undefinedColumns.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Distribute columns not defined on table: " + undefinedColumns);
        }
        return Optional.of(new ConnectorNewTableLayout((ConnectorPartitioningHandle)BlackHolePartitioningHandle.INSTANCE, distributeColumns));
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        this.checkSchemaExists(tableMetadata.getTable().getSchemaName());
        int splitCount = (Integer)tableMetadata.getProperties().get("split_count");
        int pagesPerSplit = (Integer)tableMetadata.getProperties().get("pages_per_split");
        int rowsPerPage = (Integer)tableMetadata.getProperties().get("rows_per_page");
        int fieldsLength = (Integer)tableMetadata.getProperties().get("field_length");
        if (splitCount < 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "split_count property is negative");
        }
        if (pagesPerSplit < 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "pages_per_split property is negative");
        }
        if (rowsPerPage < 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "rows_per_page property is negative");
        }
        if (!(splitCount <= 0 && pagesPerSplit <= 0 && rowsPerPage <= 0 || splitCount != 0 && pagesPerSplit != 0 && rowsPerPage != 0)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("All properties [%s, %s, %s] must be set if any are set", "split_count", "pages_per_split", "rows_per_page"));
        }
        Duration pageProcessingDelay = (Duration)tableMetadata.getProperties().get("page_processing_delay");
        BlackHoleTableHandle handle = new BlackHoleTableHandle(tableMetadata, splitCount, pagesPerSplit, rowsPerPage, fieldsLength, pageProcessingDelay);
        return new BlackHoleOutputTableHandle(handle, pageProcessingDelay);
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        BlackHoleOutputTableHandle blackHoleOutputTableHandle = (BlackHoleOutputTableHandle)tableHandle;
        BlackHoleTableHandle table = blackHoleOutputTableHandle.getTable();
        this.tables.put(table.toSchemaTableName(), table);
        return Optional.empty();
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        BlackHoleTableHandle handle = (BlackHoleTableHandle)tableHandle;
        return new BlackHoleInsertTableHandle(handle.getPageProcessingDelay());
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle handle, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        BlackHoleTableHandle blackHoleHandle = (BlackHoleTableHandle)handle;
        BlackHoleTableLayoutHandle layoutHandle = new BlackHoleTableLayoutHandle(blackHoleHandle.getSplitCount(), blackHoleHandle.getPagesPerSplit(), blackHoleHandle.getRowsPerPage(), blackHoleHandle.getFieldsLength(), blackHoleHandle.getPageProcessingDelay());
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(this.getTableLayout(session, layoutHandle), constraint.getSummary()));
    }

    public void truncateTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    private void checkSchemaExists(String schemaName) {
        if (!this.schemas.contains(schemaName)) {
            throw new SchemaNotFoundException(schemaName);
        }
    }
}

