/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet;

import com.facebook.presto.parquet.ParquetDataSource;
import com.facebook.presto.parquet.ParquetDataSourceId;
import java.util.Objects;

public abstract class AbstractParquetDataSource
implements ParquetDataSource {
    private final ParquetDataSourceId id;
    private long readTimeNanos;
    private long readBytes;

    public AbstractParquetDataSource(ParquetDataSourceId id) {
        this.id = Objects.requireNonNull(id, "id is null");
    }

    @Override
    public ParquetDataSourceId getId() {
        return this.id;
    }

    @Override
    public final long getReadBytes() {
        return this.readBytes;
    }

    @Override
    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    @Override
    public final void readFully(long position, byte[] buffer) {
        this.readFully(position, buffer, 0, buffer.length);
    }

    @Override
    public final void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) {
        this.readBytes += (long)bufferLength;
        long start = System.nanoTime();
        this.readInternal(position, buffer, bufferOffset, bufferLength);
        long currentReadTimeNanos = System.nanoTime() - start;
        this.readTimeNanos += currentReadTimeNanos;
    }

    protected abstract void readInternal(long var1, byte[] var3, int var4, int var5);
}

