/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet;

import com.facebook.presto.parquet.DictionaryPage;
import com.facebook.presto.parquet.ValuesType;
import com.facebook.presto.parquet.dictionary.BinaryDictionary;
import com.facebook.presto.parquet.dictionary.Dictionary;
import com.facebook.presto.parquet.dictionary.DictionaryReader;
import com.facebook.presto.parquet.dictionary.DoubleDictionary;
import com.facebook.presto.parquet.dictionary.FloatDictionary;
import com.facebook.presto.parquet.dictionary.IntegerDictionary;
import com.facebook.presto.parquet.dictionary.LongDictionary;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.bitpacking.ByteBitPackingValuesReader;
import org.apache.parquet.column.values.bitpacking.Packer;
import org.apache.parquet.column.values.delta.DeltaBinaryPackingValuesReader;
import org.apache.parquet.column.values.deltalengthbytearray.DeltaLengthByteArrayValuesReader;
import org.apache.parquet.column.values.deltastrings.DeltaByteArrayReader;
import org.apache.parquet.column.values.plain.BinaryPlainValuesReader;
import org.apache.parquet.column.values.plain.BooleanPlainValuesReader;
import org.apache.parquet.column.values.plain.FixedLenByteArrayPlainValuesReader;
import org.apache.parquet.column.values.plain.PlainValuesReader;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridValuesReader;
import org.apache.parquet.column.values.rle.ZeroIntegerValuesReader;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.schema.PrimitiveType;

public enum ParquetEncoding {
    PLAIN{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
            switch (descriptor.getType()) {
                case BOOLEAN: {
                    return new BooleanPlainValuesReader();
                }
                case BINARY: {
                    return new BinaryPlainValuesReader();
                }
                case FLOAT: {
                    return new PlainValuesReader.FloatPlainValuesReader();
                }
                case DOUBLE: {
                    return new PlainValuesReader.DoublePlainValuesReader();
                }
                case INT32: {
                    return new PlainValuesReader.IntegerPlainValuesReader();
                }
                case INT64: {
                    return new PlainValuesReader.LongPlainValuesReader();
                }
                case INT96: {
                    return new FixedLenByteArrayPlainValuesReader(12);
                }
                case FIXED_LEN_BYTE_ARRAY: {
                    return new FixedLenByteArrayPlainValuesReader(descriptor.getTypeLength());
                }
            }
            throw new ParquetDecodingException("Plain values reader does not support: " + descriptor.getType());
        }

        @Override
        public Dictionary initDictionary(ColumnDescriptor descriptor, DictionaryPage dictionaryPage) throws IOException {
            switch (descriptor.getType()) {
                case BINARY: {
                    return new BinaryDictionary(dictionaryPage);
                }
                case FIXED_LEN_BYTE_ARRAY: {
                    return new BinaryDictionary(dictionaryPage, descriptor.getTypeLength());
                }
                case INT96: {
                    return new BinaryDictionary(dictionaryPage, 12);
                }
                case INT64: {
                    return new LongDictionary(dictionaryPage);
                }
                case DOUBLE: {
                    return new DoubleDictionary(dictionaryPage);
                }
                case INT32: {
                    return new IntegerDictionary(dictionaryPage);
                }
                case FLOAT: {
                    return new FloatDictionary(dictionaryPage);
                }
            }
            throw new ParquetDecodingException("Dictionary encoding does not support: " + descriptor.getType());
        }
    }
    ,
    RLE{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
            int bitWidth = BytesUtils.getWidthFromMaxInt((int)2.getMaxLevel(descriptor, valuesType));
            if (bitWidth == 0) {
                return new ZeroIntegerValuesReader();
            }
            return new RunLengthBitPackingHybridValuesReader(bitWidth);
        }
    }
    ,
    BIT_PACKED{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
            return new ByteBitPackingValuesReader(3.getMaxLevel(descriptor, valuesType), Packer.BIG_ENDIAN);
        }
    }
    ,
    PLAIN_DICTIONARY{

        @Override
        public ValuesReader getDictionaryBasedValuesReader(ColumnDescriptor descriptor, ValuesType valuesType, Dictionary dictionary) {
            return RLE_DICTIONARY.getDictionaryBasedValuesReader(descriptor, valuesType, dictionary);
        }

        @Override
        public Dictionary initDictionary(ColumnDescriptor descriptor, DictionaryPage dictionaryPage) throws IOException {
            return PLAIN.initDictionary(descriptor, dictionaryPage);
        }

        @Override
        public boolean usesDictionary() {
            return true;
        }
    }
    ,
    DELTA_BINARY_PACKED{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
            Preconditions.checkArgument((descriptor.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT32 || descriptor.getType() == PrimitiveType.PrimitiveTypeName.INT64 ? 1 : 0) != 0, (Object)"Encoding DELTA_BINARY_PACKED is only supported for type INT32");
            return new DeltaBinaryPackingValuesReader();
        }
    }
    ,
    DELTA_LENGTH_BYTE_ARRAY{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
            Preconditions.checkArgument((descriptor.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.BINARY ? 1 : 0) != 0, (Object)"Encoding DELTA_LENGTH_BYTE_ARRAY is only supported for type BINARY");
            return new DeltaLengthByteArrayValuesReader();
        }
    }
    ,
    DELTA_BYTE_ARRAY{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
            Preconditions.checkArgument((descriptor.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.BINARY || descriptor.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY ? 1 : 0) != 0, (Object)"Encoding DELTA_BYTE_ARRAY is only supported for type BINARY and FIXED_LEN_BYTE_ARRAY");
            return new DeltaByteArrayReader();
        }
    }
    ,
    RLE_DICTIONARY{

        @Override
        public ValuesReader getDictionaryBasedValuesReader(ColumnDescriptor descriptor, ValuesType valuesType, Dictionary dictionary) {
            return new DictionaryReader(dictionary);
        }

        @Override
        public Dictionary initDictionary(ColumnDescriptor descriptor, DictionaryPage dictionaryPage) throws IOException {
            return PLAIN.initDictionary(descriptor, dictionaryPage);
        }

        @Override
        public boolean usesDictionary() {
            return true;
        }
    };

    static final int INT96_TYPE_LENGTH = 12;

    static int getMaxLevel(ColumnDescriptor descriptor, ValuesType valuesType) {
        switch (valuesType) {
            case REPETITION_LEVEL: {
                return descriptor.getMaxRepetitionLevel();
            }
            case DEFINITION_LEVEL: {
                return descriptor.getMaxDefinitionLevel();
            }
            case VALUES: {
                if (descriptor.getType() != PrimitiveType.PrimitiveTypeName.BOOLEAN) break;
                return 1;
            }
        }
        throw new ParquetDecodingException("Unsupported  values type: " + (Object)((Object)valuesType));
    }

    public boolean usesDictionary() {
        return false;
    }

    public Dictionary initDictionary(ColumnDescriptor descriptor, DictionaryPage dictionaryPage) throws IOException {
        throw new UnsupportedOperationException(" Dictionary encoding is not supported for: " + this.name());
    }

    public ValuesReader getValuesReader(ColumnDescriptor descriptor, ValuesType valuesType) {
        throw new UnsupportedOperationException("Error decoding  values in encoding: " + this.name());
    }

    public ValuesReader getDictionaryBasedValuesReader(ColumnDescriptor descriptor, ValuesType valuesType, Dictionary dictionary) {
        throw new UnsupportedOperationException(" Dictionary encoding is not supported for: " + this.name());
    }
}

