/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.parquet.ParquetEncoding;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.InvalidRecordException;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.Type;

public final class ParquetTypeUtils {
    private ParquetTypeUtils() {
    }

    public static List<PrimitiveColumnIO> getColumns(MessageType fileSchema, MessageType requestedSchema) {
        return new ColumnIOFactory().getColumnIO(requestedSchema, fileSchema, true).getLeaves();
    }

    public static MessageColumnIO getColumnIO(MessageType fileSchema, MessageType requestedSchema) {
        return new ColumnIOFactory().getColumnIO(requestedSchema, fileSchema, true);
    }

    public static GroupColumnIO getMapKeyValueColumn(GroupColumnIO groupColumnIO) {
        while (groupColumnIO.getChildrenCount() == 1) {
            groupColumnIO = (GroupColumnIO)groupColumnIO.getChild(0);
        }
        return groupColumnIO;
    }

    public static ColumnIO getArrayElementColumn(ColumnIO columnIO) {
        while (columnIO instanceof GroupColumnIO && !columnIO.getType().isRepetition(Type.Repetition.REPEATED)) {
            columnIO = ((GroupColumnIO)columnIO).getChild(0);
        }
        if (columnIO instanceof GroupColumnIO && columnIO.getType().getOriginalType() == null && ((GroupColumnIO)columnIO).getChildrenCount() == 1 && !columnIO.getName().equals("array") && !columnIO.getName().equals(columnIO.getParent().getName() + "_tuple")) {
            return ((GroupColumnIO)columnIO).getChild(0);
        }
        return columnIO;
    }

    public static Map<List<String>, RichColumnDescriptor> getDescriptors(MessageType fileSchema, MessageType requestedSchema) {
        HashMap<List<String>, RichColumnDescriptor> descriptorsByPath = new HashMap<List<String>, RichColumnDescriptor>();
        List<PrimitiveColumnIO> columns = ParquetTypeUtils.getColumns(fileSchema, requestedSchema);
        for (String[] paths : fileSchema.getPaths()) {
            List<String> columnPath = Arrays.asList(paths);
            ParquetTypeUtils.getDescriptor(columns, columnPath).ifPresent(richColumnDescriptor -> descriptorsByPath.put(columnPath, (RichColumnDescriptor)((Object)richColumnDescriptor)));
        }
        return descriptorsByPath;
    }

    public static Optional<RichColumnDescriptor> getDescriptor(List<PrimitiveColumnIO> columns, List<String> path) {
        Preconditions.checkArgument((path.size() >= 1 ? 1 : 0) != 0, (Object)"Parquet nested path should have at least one component");
        int index = ParquetTypeUtils.getPathIndex(columns, path);
        if (index == -1) {
            return Optional.empty();
        }
        PrimitiveColumnIO columnIO = columns.get(index);
        return Optional.of(new RichColumnDescriptor(columnIO.getColumnDescriptor(), columnIO.getType().asPrimitiveType()));
    }

    private static int getPathIndex(List<PrimitiveColumnIO> columns, List<String> path) {
        int maxLevel = path.size();
        int index = -1;
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            ColumnIO[] fields = columns.get(columnIndex).getPath();
            if (fields.length <= maxLevel || !fields[maxLevel].getName().equalsIgnoreCase(path.get(maxLevel - 1))) continue;
            boolean match = true;
            for (int level = 0; level < maxLevel - 1; ++level) {
                if (fields[level + 1].getName().equalsIgnoreCase(path.get(level))) continue;
                match = false;
            }
            if (!match) continue;
            index = columnIndex;
        }
        return index;
    }

    public static int getFieldIndex(MessageType fileSchema, String name) {
        try {
            return fileSchema.getFieldIndex(name.toLowerCase(Locale.ENGLISH));
        }
        catch (InvalidRecordException e) {
            for (Type type : fileSchema.getFields()) {
                if (!type.getName().equalsIgnoreCase(name)) continue;
                return fileSchema.getFieldIndex(type.getName());
            }
            return -1;
        }
    }

    public static ParquetEncoding getParquetEncoding(Encoding encoding) {
        switch (encoding) {
            case PLAIN: {
                return ParquetEncoding.PLAIN;
            }
            case RLE: {
                return ParquetEncoding.RLE;
            }
            case BIT_PACKED: {
                return ParquetEncoding.BIT_PACKED;
            }
            case PLAIN_DICTIONARY: {
                return ParquetEncoding.PLAIN_DICTIONARY;
            }
            case DELTA_BINARY_PACKED: {
                return ParquetEncoding.DELTA_BINARY_PACKED;
            }
            case DELTA_LENGTH_BYTE_ARRAY: {
                return ParquetEncoding.DELTA_LENGTH_BYTE_ARRAY;
            }
            case DELTA_BYTE_ARRAY: {
                return ParquetEncoding.DELTA_BYTE_ARRAY;
            }
            case RLE_DICTIONARY: {
                return ParquetEncoding.RLE_DICTIONARY;
            }
        }
        throw new ParquetDecodingException("Unsupported Parquet encoding: " + encoding);
    }

    public static Type getParquetTypeByName(String columnName, GroupType messageType) {
        if (messageType.containsField(columnName)) {
            return messageType.getType(columnName);
        }
        for (Type type : messageType.getFields()) {
            if (!type.getName().equalsIgnoreCase(columnName)) continue;
            return type;
        }
        return null;
    }

    public static ColumnIO lookupColumnByName(GroupColumnIO groupColumnIO, String columnName) {
        ColumnIO columnIO = groupColumnIO.getChild(columnName);
        if (columnIO != null) {
            return columnIO;
        }
        for (int i = 0; i < groupColumnIO.getChildrenCount(); ++i) {
            if (!groupColumnIO.getChild(i).getName().equalsIgnoreCase(columnName)) continue;
            return groupColumnIO.getChild(i);
        }
        return null;
    }

    public static Optional<com.facebook.presto.common.type.Type> createDecimalType(RichColumnDescriptor descriptor) {
        if (descriptor.getPrimitiveType().getOriginalType() != OriginalType.DECIMAL) {
            return Optional.empty();
        }
        return Optional.of(ParquetTypeUtils.createDecimalType(descriptor.getPrimitiveType().getDecimalMetadata()));
    }

    private static com.facebook.presto.common.type.Type createDecimalType(DecimalMetadata decimalMetadata) {
        return DecimalType.createDecimalType((int)decimalMetadata.getPrecision(), (int)decimalMetadata.getScale());
    }

    public static boolean isValueNull(boolean required, int definitionLevel, int maxDefinitionLevel) {
        return !required && definitionLevel == maxDefinitionLevel - 1;
    }

    public static long getShortDecimalValue(byte[] bytes) {
        int i;
        long value = 0L;
        if ((bytes[0] & 0x80) != 0) {
            for (i = 0; i < 8 - bytes.length; ++i) {
                value |= 255L << 8 * (7 - i);
            }
        }
        for (i = 0; i < bytes.length; ++i) {
            value |= ((long)bytes[bytes.length - i - 1] & 0xFFL) << 8 * i;
        }
        return value;
    }

    public static Optional<Type> getSubfieldType(GroupType baseType, String rootName, List<String> nestedColumnPath) {
        Preconditions.checkArgument((nestedColumnPath.size() >= 1 ? 1 : 0) != 0, (Object)"subfield size is less than 1");
        ImmutableList.Builder typeBuilder = ImmutableList.builder();
        Type parentType = ParquetTypeUtils.getParquetTypeByName(rootName, baseType.asGroupType());
        if (parentType == null) {
            return Optional.empty();
        }
        typeBuilder.add((Object)parentType);
        for (String field : nestedColumnPath) {
            Type childType = ParquetTypeUtils.getParquetTypeByName(field, parentType.asGroupType());
            if (childType == null) {
                return Optional.empty();
            }
            typeBuilder.add((Object)childType);
            parentType = childType;
        }
        ImmutableList typeChain = typeBuilder.build();
        if (typeChain.isEmpty()) {
            return Optional.empty();
        }
        if (typeChain.size() == 1) {
            return Optional.of(Iterables.getOnlyElement((Iterable)typeChain));
        }
        Type messageType = (Type)typeChain.get(typeChain.size() - 1);
        for (int i = typeChain.size() - 2; i >= 0; --i) {
            GroupType groupType = ((Type)typeChain.get(i)).asGroupType();
            messageType = new MessageType(groupType.getName(), (List)ImmutableList.of((Object)messageType));
        }
        return Optional.of(messageType);
    }

    public static List<String> nestedColumnPath(Subfield subfield) {
        ImmutableList.Builder nestedColumnPathBuilder = ImmutableList.builder();
        for (Subfield.PathElement pathElement : subfield.getPath()) {
            Preconditions.checkArgument((boolean)(pathElement instanceof Subfield.NestedField), (Object)("Unsupported subfield. Expected only nested field path elements. " + subfield));
            nestedColumnPathBuilder.add((Object)((Subfield.NestedField)pathElement).getName());
        }
        return nestedColumnPathBuilder.build();
    }

    public static String pushdownColumnNameForSubfield(Subfield subfield) {
        return ParquetTypeUtils.columnPathFromSubfield(subfield).stream().collect(Collectors.joining("$_$_$"));
    }

    public static List<String> columnPathFromSubfield(Subfield subfield) {
        ImmutableList.Builder columnPath = ImmutableList.builder();
        columnPath.add((Object)subfield.getRootName());
        columnPath.addAll(ParquetTypeUtils.nestedColumnPath(subfield));
        return columnPath.build();
    }

    public static boolean isTimeStampMicrosType(ColumnDescriptor descriptor) {
        return OriginalType.TIMESTAMP_MICROS.equals((Object)descriptor.getPrimitiveType().getOriginalType());
    }
}

