/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader;

public class BytesUtils {
    private BytesUtils() {
    }

    public static final int getInt(byte[] byteBuffer, int offset) {
        int ch0 = byteBuffer[offset + 0] & 0xFF;
        int ch1 = byteBuffer[offset + 1] & 0xFF;
        int ch2 = byteBuffer[offset + 2] & 0xFF;
        int ch3 = byteBuffer[offset + 3] & 0xFF;
        return (ch3 << 24) + (ch2 << 16) + (ch1 << 8) + ch0;
    }

    public static final long getLong(byte[] byteBuffer, int offset) {
        byte ch0 = byteBuffer[offset + 0];
        byte ch1 = byteBuffer[offset + 1];
        byte ch2 = byteBuffer[offset + 2];
        byte ch3 = byteBuffer[offset + 3];
        byte ch4 = byteBuffer[offset + 4];
        byte ch5 = byteBuffer[offset + 5];
        byte ch6 = byteBuffer[offset + 6];
        byte ch7 = byteBuffer[offset + 7];
        return ((long)(ch7 & 0xFF) << 56) + ((long)(ch6 & 0xFF) << 48) + ((long)(ch5 & 0xFF) << 40) + ((long)(ch4 & 0xFF) << 32) + ((long)(ch3 & 0xFF) << 24) + ((long)(ch2 & 0xFF) << 16) + ((long)(ch1 & 0xFF) << 8) + ((long)(ch0 & 0xFF) << 0);
    }

    public static void unpack8Values(byte inByte, byte[] out, int outPos) {
        out[0 + outPos] = (byte)(inByte & 1);
        out[1 + outPos] = (byte)(inByte >> 1 & 1);
        out[2 + outPos] = (byte)(inByte >> 2 & 1);
        out[3 + outPos] = (byte)(inByte >> 3 & 1);
        out[4 + outPos] = (byte)(inByte >> 4 & 1);
        out[5 + outPos] = (byte)(inByte >> 5 & 1);
        out[6 + outPos] = (byte)(inByte >> 6 & 1);
        out[7 + outPos] = (byte)(inByte >> 7 & 1);
    }
}

