/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders;

import com.facebook.presto.parquet.batchreader.decoders.rle.BaseRLEBitPackedDecoder;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import org.apache.parquet.io.ParquetDecodingException;

public class FlatDefinitionLevelDecoder
extends BaseRLEBitPackedDecoder {
    public FlatDefinitionLevelDecoder(int valueCount, InputStream inputStream) {
        super(valueCount, 1, inputStream);
    }

    public FlatDefinitionLevelDecoder(int rleValue, int valueCount) {
        super(rleValue, valueCount);
    }

    public int readNext(boolean[] values, int offset, int length) throws IOException {
        int remainingToCopy;
        int chunkSize;
        int nonNullCount = 0;
        int destinationIndex = offset;
        for (remainingToCopy = length; remainingToCopy > 0 && (this.currentCount != 0 || this.decode()); remainingToCopy -= chunkSize) {
            chunkSize = Math.min(remainingToCopy, this.currentCount);
            int endIndex = destinationIndex + chunkSize;
            switch (this.mode) {
                case RLE: {
                    boolean rleValue;
                    boolean bl = rleValue = this.currentValue == 0;
                    while (destinationIndex < endIndex) {
                        values[destinationIndex++] = rleValue;
                    }
                    nonNullCount += this.currentValue * chunkSize;
                    break;
                }
                case PACKED: {
                    int[] buffer = this.currentBuffer;
                    int sourceIndex = buffer.length - this.currentCount;
                    while (destinationIndex < endIndex) {
                        int value = buffer[sourceIndex];
                        values[destinationIndex] = value == 0;
                        nonNullCount += value;
                        ++sourceIndex;
                        ++destinationIndex;
                    }
                    break;
                }
                default: {
                    throw new ParquetDecodingException("not a valid mode " + (Object)((Object)this.mode));
                }
            }
            this.currentCount -= chunkSize;
        }
        Preconditions.checkState((remainingToCopy == 0 ? 1 : 0) != 0, (Object)"Failed to copy the requested number of definition levels");
        return nonNullCount;
    }
}

