/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders.rle;

import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.rle.BaseRLEBitPackedDecoder;
import com.facebook.presto.parquet.dictionary.IntegerDictionary;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import org.apache.parquet.io.ParquetDecodingException;

public class Int32RLEDictionaryValuesDecoder
extends BaseRLEBitPackedDecoder
implements ValuesDecoder.Int32ValuesDecoder {
    private final IntegerDictionary dictionary;

    public Int32RLEDictionaryValuesDecoder(int bitWidth, InputStream in, IntegerDictionary dictionary) {
        super(Integer.MAX_VALUE, bitWidth, in);
        this.dictionary = dictionary;
    }

    @Override
    public void readNext(int[] values, int offset, int length) throws IOException {
        int numEntriesToFill;
        int destinationIndex = offset;
        for (int remainingToCopy = length; remainingToCopy > 0 && (this.currentCount != 0 || this.decode()); remainingToCopy -= numEntriesToFill) {
            numEntriesToFill = Math.min(remainingToCopy, this.currentCount);
            int endIndex = destinationIndex + numEntriesToFill;
            switch (this.mode) {
                case RLE: {
                    int rleValue = this.currentValue;
                    int rleDictionaryValue = this.dictionary.decodeToInt(rleValue);
                    while (destinationIndex < endIndex) {
                        values[destinationIndex++] = rleDictionaryValue;
                    }
                    break;
                }
                case PACKED: {
                    int[] localCurrentBuffer = this.currentBuffer;
                    IntegerDictionary localDictionary = this.dictionary;
                    int sourceIndex = this.currentBuffer.length - this.currentCount;
                    while (destinationIndex < endIndex) {
                        int dictionaryValue = localDictionary.decodeToInt(localCurrentBuffer[sourceIndex]);
                        values[destinationIndex++] = dictionaryValue;
                        ++sourceIndex;
                    }
                    break;
                }
                default: {
                    throw new ParquetDecodingException("not a valid mode " + (Object)((Object)this.mode));
                }
            }
            this.currentCount -= numEntriesToFill;
        }
    }

    @Override
    public void skip(int length) throws IOException {
        int remaining;
        int chunkSize;
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (String)"invalid length %s", (int)length);
        for (remaining = length; remaining > 0 && (this.currentCount != 0 || this.decode()); remaining -= chunkSize) {
            chunkSize = Math.min(remaining, this.currentCount);
            this.currentCount -= chunkSize;
        }
        Preconditions.checkState((remaining == 0 ? 1 : 0) != 0, (String)"End of stream: Invalid skip size request: %s", (int)length);
    }
}

