/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.dictionary;

import com.facebook.presto.parquet.DictionaryPage;
import com.facebook.presto.parquet.ParquetTimestampUtils;
import com.facebook.presto.parquet.dictionary.Dictionary;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class TimestampDictionary
extends Dictionary {
    private final long[] dictionary;

    public TimestampDictionary(DictionaryPage dictionaryPage) {
        super(dictionaryPage.getEncoding());
        Objects.requireNonNull(dictionaryPage, "dictionaryPage is null");
        Preconditions.checkArgument((dictionaryPage.getDictionarySize() >= 0 ? 1 : 0) != 0, (Object)"Dictionary size should be greater than or equal zero");
        Preconditions.checkArgument((dictionaryPage.getSlice().length() >= 12 * dictionaryPage.getDictionarySize() ? 1 : 0) != 0, (Object)"Dictionary buffer size is less than expected");
        int dictionarySize = dictionaryPage.getDictionarySize();
        byte[] pageBuffer = Objects.requireNonNull(dictionaryPage.getSlice(), "dictionary slice is null").getBytes();
        long[] dictionary = new long[dictionarySize];
        int offset = 0;
        for (int i = 0; i < dictionarySize; ++i) {
            dictionary[i] = ParquetTimestampUtils.getTimestampMillis(pageBuffer, offset);
            offset += 12;
        }
        this.dictionary = dictionary;
    }

    @Override
    public long decodeToLong(int id) {
        return this.dictionary[id];
    }
}

