/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import com.facebook.presto.common.block.ArrayBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.IntArrayBlock;
import com.facebook.presto.common.block.LongArrayBlock;
import com.facebook.presto.common.block.RowBlock;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.parquet.ColumnReader;
import com.facebook.presto.parquet.ColumnReaderFactory;
import com.facebook.presto.parquet.Field;
import com.facebook.presto.parquet.GroupField;
import com.facebook.presto.parquet.ParquetCorruptionException;
import com.facebook.presto.parquet.ParquetDataSource;
import com.facebook.presto.parquet.ParquetResultVerifierUtils;
import com.facebook.presto.parquet.ParquetValidationUtils;
import com.facebook.presto.parquet.PrimitiveField;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.predicate.Predicate;
import com.facebook.presto.parquet.predicate.TupleDomainParquetPredicate;
import com.facebook.presto.parquet.reader.ColumnChunk;
import com.facebook.presto.parquet.reader.ColumnChunkDescriptor;
import com.facebook.presto.parquet.reader.ColumnIndexFilterUtils;
import com.facebook.presto.parquet.reader.ListColumnReader;
import com.facebook.presto.parquet.reader.PageReader;
import com.facebook.presto.parquet.reader.ParquetColumnChunk;
import com.facebook.presto.parquet.reader.StructColumnReader;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.internal.filter2.columnindex.ColumnIndexFilter;
import org.apache.parquet.internal.filter2.columnindex.ColumnIndexStore;
import org.apache.parquet.internal.filter2.columnindex.RowRanges;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.schema.PrimitiveType;

public class ParquetReader
implements Closeable {
    private static final int MAX_VECTOR_LENGTH = 1024;
    private static final int INITIAL_BATCH_SIZE = 1;
    private static final int BATCH_SIZE_GROWTH_FACTOR = 2;
    private final List<BlockMetaData> blocks;
    private final Optional<List<Long>> firstRowsOfBlocks;
    private final List<PrimitiveColumnIO> columns;
    private final ParquetDataSource dataSource;
    private final AggregatedMemoryContext systemMemoryContext;
    private final boolean batchReadEnabled;
    private final boolean enableVerification;
    private final FilterPredicate filter;
    private int currentBlock;
    private BlockMetaData currentBlockMetadata;
    private long currentPosition;
    private long currentGroupRowCount;
    private Optional<Long> firstRowIndexInGroup = Optional.empty();
    private RowRanges currentGroupRowRanges;
    private long nextRowInGroup;
    private int batchSize;
    private int nextBatchSize = 1;
    private final ColumnReader[] columnReaders;
    protected final ColumnReader[] verificationColumnReaders;
    private long[] maxBytesPerCell;
    private long maxCombinedBytesPerRow;
    private final long maxReadBlockBytes;
    private int maxBatchSize = 1024;
    private AggregatedMemoryContext currentRowGroupMemoryContext;
    private final List<ColumnIndexStore> blockIndexStores;
    private final List<RowRanges> blockRowRanges;
    private final Map<ColumnPath, ColumnDescriptor> paths = new HashMap<ColumnPath, ColumnDescriptor>();
    private final boolean columnIndexFilterEnabled;

    public ParquetReader(MessageColumnIO messageColumnIO, List<BlockMetaData> blocks, Optional<List<Long>> firstRowsOfBlocks, ParquetDataSource dataSource, AggregatedMemoryContext systemMemoryContext, DataSize maxReadBlockSize, boolean batchReadEnabled, boolean enableVerification, Predicate parquetPredicate, List<ColumnIndexStore> blockIndexStores, boolean columnIndexFilterEnabled) {
        this.blocks = blocks;
        this.firstRowsOfBlocks = Objects.requireNonNull(firstRowsOfBlocks, "firstRowsOfBlocks is null");
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource is null");
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
        this.currentRowGroupMemoryContext = systemMemoryContext.newAggregatedMemoryContext();
        this.maxReadBlockBytes = Objects.requireNonNull(maxReadBlockSize, "maxReadBlockSize is null").toBytes();
        this.batchReadEnabled = batchReadEnabled;
        this.columns = messageColumnIO.getLeaves();
        this.columnReaders = new ColumnReader[this.columns.size()];
        this.enableVerification = enableVerification;
        this.verificationColumnReaders = enableVerification ? new ColumnReader[this.columns.size()] : null;
        this.maxBytesPerCell = new long[this.columns.size()];
        this.blockIndexStores = blockIndexStores;
        this.blockRowRanges = ParquetReader.listWithNulls(this.blocks.size());
        firstRowsOfBlocks.ifPresent(firstRows -> Preconditions.checkArgument((blocks.size() == firstRows.size() ? 1 : 0) != 0, (Object)"elements of firstRowsOfBlocks must correspond to blocks"));
        for (PrimitiveColumnIO column : this.columns) {
            ColumnDescriptor columnDescriptor = column.getColumnDescriptor();
            this.paths.put(ColumnPath.get((String[])columnDescriptor.getPath()), columnDescriptor);
        }
        this.filter = parquetPredicate != null && columnIndexFilterEnabled && parquetPredicate instanceof TupleDomainParquetPredicate ? ((TupleDomainParquetPredicate)parquetPredicate).getParquetUserDefinedPredicate() : null;
        this.currentBlock = -1;
        this.columnIndexFilterEnabled = columnIndexFilterEnabled;
    }

    @Override
    public void close() throws IOException {
        this.currentRowGroupMemoryContext.close();
        this.dataSource.close();
    }

    public long getPosition() {
        return this.currentPosition;
    }

    public long lastBatchStartRow() {
        long baseIndex = this.firstRowIndexInGroup.orElseThrow(() -> new IllegalStateException("row index unavailable"));
        return baseIndex + this.nextRowInGroup - (long)this.batchSize;
    }

    public int nextBatch() {
        if (this.nextRowInGroup >= this.currentGroupRowCount && !this.advanceToNextRowGroup()) {
            return -1;
        }
        this.batchSize = Math.toIntExact(Math.min(this.nextBatchSize, this.maxBatchSize));
        this.nextBatchSize = Math.min(this.batchSize * 2, 1024);
        this.batchSize = Math.toIntExact(Math.min((long)this.batchSize, this.currentGroupRowCount - this.nextRowInGroup));
        this.nextRowInGroup += (long)this.batchSize;
        this.currentPosition += (long)this.batchSize;
        Arrays.stream(this.columnReaders).forEach(reader -> reader.prepareNextRead(this.batchSize));
        if (this.enableVerification) {
            Arrays.stream(this.verificationColumnReaders).forEach(reader -> reader.prepareNextRead(this.batchSize));
        }
        return this.batchSize;
    }

    private boolean advanceToNextRowGroup() {
        ColumnIndexStore columnIndexStore;
        ++this.currentBlock;
        this.currentRowGroupMemoryContext.close();
        this.currentRowGroupMemoryContext = this.systemMemoryContext.newAggregatedMemoryContext();
        if (this.currentBlock == this.blocks.size()) {
            return false;
        }
        this.currentBlockMetadata = this.blocks.get(this.currentBlock);
        this.firstRowIndexInGroup = this.firstRowsOfBlocks.map(firstRows -> (Long)firstRows.get(this.currentBlock));
        if (this.filter != null && this.columnIndexFilterEnabled && (columnIndexStore = this.blockIndexStores.get(this.currentBlock)) != null) {
            this.currentGroupRowRanges = this.getRowRanges(this.currentBlock);
            long rowCount = this.currentGroupRowRanges.rowCount();
            if (rowCount == 0L) {
                return false;
            }
        }
        this.nextRowInGroup = 0L;
        this.currentGroupRowCount = this.currentBlockMetadata.getRowCount();
        this.initializeColumnReaders();
        return true;
    }

    private ColumnChunk readArray(GroupField field) throws IOException {
        List parameters = field.getType().getTypeParameters();
        Preconditions.checkArgument((parameters.size() == 1 ? 1 : 0) != 0, (String)"Arrays must have a single type parameter, found %d", (int)parameters.size());
        Field elementField = field.getChildren().get(0).get();
        ColumnChunk columnChunk = this.readColumnChunk(elementField);
        IntArrayList offsets = new IntArrayList();
        BooleanArrayList valueIsNull = new BooleanArrayList();
        ListColumnReader.calculateCollectionOffsets(field, (IntList)offsets, (BooleanList)valueIsNull, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
        Block arrayBlock = ArrayBlock.fromElementBlock((int)valueIsNull.size(), Optional.of(valueIsNull.toBooleanArray()), (int[])offsets.toIntArray(), (Block)columnChunk.getBlock());
        return new ColumnChunk(arrayBlock, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
    }

    private ColumnChunk readMap(GroupField field) throws IOException {
        List parameters = field.getType().getTypeParameters();
        Preconditions.checkArgument((parameters.size() == 2 ? 1 : 0) != 0, (String)"Maps must have two type parameters, found %d", (int)parameters.size());
        Block[] blocks = new Block[parameters.size()];
        ColumnChunk columnChunk = this.readColumnChunk(field.getChildren().get(0).get());
        blocks[0] = columnChunk.getBlock();
        blocks[1] = this.readColumnChunk(field.getChildren().get(1).get()).getBlock();
        IntArrayList offsets = new IntArrayList();
        BooleanArrayList valueIsNull = new BooleanArrayList();
        ListColumnReader.calculateCollectionOffsets(field, (IntList)offsets, (BooleanList)valueIsNull, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
        Block mapBlock = ((MapType)field.getType()).createBlockFromKeyValue(offsets.size() - 1, Optional.of(valueIsNull.toBooleanArray()), offsets.toIntArray(), blocks[0], blocks[1]);
        return new ColumnChunk(mapBlock, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
    }

    private ColumnChunk readStruct(GroupField field) throws IOException {
        int i;
        List fields = field.getType().getTypeSignature().getParameters();
        Block[] blocks = new Block[fields.size()];
        ColumnChunk columnChunk = null;
        List<Optional<Field>> parameters = field.getChildren();
        for (i = 0; i < fields.size(); ++i) {
            Optional<Field> parameter = parameters.get(i);
            if (!parameter.isPresent()) continue;
            columnChunk = this.readColumnChunk(parameter.get());
            blocks[i] = columnChunk.getBlock();
        }
        for (i = 0; i < fields.size(); ++i) {
            if (blocks[i] != null) continue;
            blocks[i] = RunLengthEncodedBlock.create((Type)field.getType(), null, (int)columnChunk.getBlock().getPositionCount());
        }
        BooleanList structIsNull = StructColumnReader.calculateStructOffsets(field, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
        boolean[] structIsNullVector = structIsNull.toBooleanArray();
        Block rowBlock = RowBlock.fromFieldBlocks((int)structIsNullVector.length, Optional.of(structIsNullVector), (Block[])blocks);
        return new ColumnChunk(rowBlock, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
    }

    private ColumnChunk readPrimitive(PrimitiveField field) throws IOException {
        long bytesPerCell;
        RichColumnDescriptor columnDescriptor = field.getDescriptor();
        int fieldId = field.getId();
        ColumnReader columnReader = this.columnReaders[fieldId];
        if (!columnReader.isInitialized()) {
            ParquetValidationUtils.validateParquet(this.currentBlockMetadata.getRowCount() > 0L, "Row group has 0 rows", new Object[0]);
            ColumnChunkMetaData metadata = this.getColumnChunkMetaData(columnDescriptor);
            long startingPosition = metadata.getStartingPos();
            int totalSize = Math.toIntExact(metadata.getTotalSize());
            if (this.shouldUseColumnIndex(metadata.getPath())) {
                OffsetIndex offsetIndex = this.blockIndexStores.get(this.currentBlock).getOffsetIndex(metadata.getPath());
                OffsetIndex filteredOffsetIndex = ColumnIndexFilterUtils.filterOffsetIndex(offsetIndex, this.currentGroupRowRanges, this.blocks.get(this.currentBlock).getRowCount());
                List<ColumnIndexFilterUtils.OffsetRange> offsetRanges = ColumnIndexFilterUtils.calculateOffsetRanges(filteredOffsetIndex, metadata, offsetIndex.getOffset(0), startingPosition);
                List<ColumnIndexFilterUtils.OffsetRange> consecutiveRanges = this.concatRanges(offsetRanges);
                List<ByteBuffer> buffers = this.allocateBlocks(consecutiveRanges);
                for (int i = 0; i < consecutiveRanges.size(); ++i) {
                    ByteBuffer buffer = buffers.get(i);
                    this.dataSource.readFully(startingPosition + consecutiveRanges.get(i).getOffset(), buffer.array());
                }
                PageReader pageReader = this.createPageReader(buffers, totalSize, metadata, columnDescriptor, filteredOffsetIndex);
                columnReader.init(pageReader, field, this.currentGroupRowRanges);
                if (this.enableVerification) {
                    ColumnReader verificationColumnReader = this.verificationColumnReaders[field.getId()];
                    PageReader pageReaderVerification = this.createPageReader(buffers, totalSize, metadata, columnDescriptor, filteredOffsetIndex);
                    verificationColumnReader.init(pageReaderVerification, field, this.currentGroupRowRanges);
                }
            } else {
                byte[] buffer = this.allocateBlock(totalSize);
                this.dataSource.readFully(startingPosition, buffer);
                PageReader pageReader = this.createPageReader(buffer, totalSize, metadata, columnDescriptor);
                columnReader.init(pageReader, field, null);
                if (this.enableVerification) {
                    ColumnReader verificationColumnReader = this.verificationColumnReaders[field.getId()];
                    PageReader pageReaderVerification = this.createPageReader(buffer, totalSize, metadata, columnDescriptor);
                    verificationColumnReader.init(pageReaderVerification, field, null);
                }
            }
        }
        ColumnChunk columnChunk = columnReader.readNext();
        columnChunk = ParquetReader.typeCoercion(columnChunk, field.getDescriptor().getPrimitiveType().getPrimitiveTypeName(), field.getType());
        if (this.enableVerification) {
            ColumnReader verificationColumnReader = this.verificationColumnReaders[field.getId()];
            ColumnChunk expected = verificationColumnReader.readNext();
            ParquetResultVerifierUtils.verifyColumnChunks(columnChunk, expected, columnDescriptor.getPath().length > 1, field, this.dataSource.getId());
        }
        if (this.maxBytesPerCell[fieldId] < (bytesPerCell = columnChunk.getBlock().getSizeInBytes() / (long)this.batchSize)) {
            this.maxCombinedBytesPerRow = this.maxCombinedBytesPerRow - this.maxBytesPerCell[fieldId] + bytesPerCell;
            this.maxBatchSize = Math.toIntExact(Math.min((long)this.maxBatchSize, Math.max(1L, this.maxReadBlockBytes / this.maxCombinedBytesPerRow)));
            this.maxBytesPerCell[fieldId] = bytesPerCell;
        }
        return columnChunk;
    }

    private boolean shouldUseColumnIndex(ColumnPath path) {
        return this.filter != null && this.columnIndexFilterEnabled && this.currentGroupRowRanges != null && this.currentGroupRowRanges.rowCount() < this.currentGroupRowCount && this.blockIndexStores.get(this.currentBlock) != null && this.blockIndexStores.get(this.currentBlock).getColumnIndex(path) != null;
    }

    private List<ByteBuffer> allocateBlocks(List<ColumnIndexFilterUtils.OffsetRange> pageRanges) {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        for (ColumnIndexFilterUtils.OffsetRange pageRange : pageRanges) {
            buffers.add(ByteBuffer.wrap(this.allocateBlock(pageRange.getLength())));
        }
        return buffers;
    }

    protected PageReader createPageReader(List<ByteBuffer> buffers, int bufferSize, ColumnChunkMetaData metadata, ColumnDescriptor columnDescriptor, OffsetIndex offsetIndex) throws IOException {
        ColumnChunkDescriptor descriptor = new ColumnChunkDescriptor(columnDescriptor, metadata, bufferSize);
        ParquetColumnChunk columnChunk = new ParquetColumnChunk(descriptor, buffers, offsetIndex);
        return columnChunk.readAllPages();
    }

    protected PageReader createPageReader(byte[] buffer, int bufferSize, ColumnChunkMetaData metadata, ColumnDescriptor columnDescriptor) throws IOException {
        ColumnChunkDescriptor descriptor = new ColumnChunkDescriptor(columnDescriptor, metadata, bufferSize);
        ParquetColumnChunk columnChunk = new ParquetColumnChunk(descriptor, buffer, 0);
        return columnChunk.readAllPages();
    }

    protected byte[] allocateBlock(long length) {
        byte[] buffer = new byte[Math.toIntExact(length)];
        LocalMemoryContext blockMemoryContext = this.currentRowGroupMemoryContext.newLocalMemoryContext(ParquetReader.class.getSimpleName());
        blockMemoryContext.setBytes((long)buffer.length);
        return buffer;
    }

    private ColumnChunkMetaData getColumnChunkMetaData(ColumnDescriptor columnDescriptor) throws IOException {
        for (ColumnChunkMetaData metadata : this.currentBlockMetadata.getColumns()) {
            if (!metadata.getPath().equals((Object)ColumnPath.get((String[])columnDescriptor.getPath()))) continue;
            return metadata;
        }
        throw new ParquetCorruptionException("Metadata is missing for column: %s", columnDescriptor);
    }

    private void initializeColumnReaders() {
        for (PrimitiveColumnIO columnIO : this.columns) {
            RichColumnDescriptor column = new RichColumnDescriptor(columnIO.getColumnDescriptor(), columnIO.getType().asPrimitiveType());
            this.columnReaders[columnIO.getId()] = ColumnReaderFactory.createReader(column, this.batchReadEnabled);
            if (!this.enableVerification) continue;
            this.verificationColumnReaders[columnIO.getId()] = ColumnReaderFactory.createReader(column, false);
        }
    }

    public Block readBlock(Field field) throws IOException {
        return this.readColumnChunk(field).getBlock();
    }

    private ColumnChunk readColumnChunk(Field field) throws IOException {
        ColumnChunk columnChunk = "row".equals(field.getType().getTypeSignature().getBase()) ? this.readStruct((GroupField)field) : ("map".equals(field.getType().getTypeSignature().getBase()) ? this.readMap((GroupField)field) : ("array".equals(field.getType().getTypeSignature().getBase()) ? this.readArray((GroupField)field) : this.readPrimitive((PrimitiveField)field)));
        return columnChunk;
    }

    public ParquetDataSource getDataSource() {
        return this.dataSource;
    }

    public AggregatedMemoryContext getSystemMemoryContext() {
        return this.systemMemoryContext;
    }

    private static ColumnChunk typeCoercion(ColumnChunk columnChunk, PrimitiveType.PrimitiveTypeName physicalDataType, Type outputType) {
        Block newBlock = null;
        if (SmallintType.SMALLINT.equals((Object)outputType) || TinyintType.TINYINT.equals((Object)outputType)) {
            if (columnChunk.getBlock() instanceof IntArrayBlock) {
                newBlock = ParquetReader.rewriteIntegerArrayBlock((IntArrayBlock)columnChunk.getBlock(), outputType);
            } else if (columnChunk.getBlock() instanceof LongArrayBlock) {
                newBlock = ParquetReader.rewriteLongArrayBlock((LongArrayBlock)columnChunk.getBlock(), outputType);
            }
        } else if (IntegerType.INTEGER.equals((Object)outputType) && physicalDataType == PrimitiveType.PrimitiveTypeName.INT64) {
            if (columnChunk.getBlock() instanceof LongArrayBlock) {
                newBlock = ParquetReader.rewriteLongArrayBlock((LongArrayBlock)columnChunk.getBlock(), outputType);
            }
        } else if (BigintType.BIGINT.equals((Object)outputType) && physicalDataType == PrimitiveType.PrimitiveTypeName.INT32 && columnChunk.getBlock() instanceof IntArrayBlock) {
            newBlock = ParquetReader.rewriteIntegerArrayBlock((IntArrayBlock)columnChunk.getBlock(), outputType);
        }
        if (newBlock != null) {
            return new ColumnChunk(newBlock, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
        }
        return columnChunk;
    }

    private static Block rewriteIntegerArrayBlock(IntArrayBlock intArrayBlock, Type targetType) {
        int positionCount = intArrayBlock.getPositionCount();
        BlockBuilder newBlockBuilder = targetType.createBlockBuilder(null, positionCount);
        for (int position = 0; position < positionCount; ++position) {
            if (intArrayBlock.isNull(position)) {
                newBlockBuilder.appendNull();
                continue;
            }
            targetType.writeLong(newBlockBuilder, (long)intArrayBlock.getInt(position));
        }
        return newBlockBuilder.build();
    }

    private static Block rewriteLongArrayBlock(LongArrayBlock longArrayBlock, Type targetType) {
        int positionCount = longArrayBlock.getPositionCount();
        BlockBuilder newBlockBuilder = targetType.createBlockBuilder(null, positionCount);
        for (int position = 0; position < positionCount; ++position) {
            if (longArrayBlock.isNull(position)) {
                newBlockBuilder.appendNull();
                continue;
            }
            targetType.writeLong(newBlockBuilder, longArrayBlock.getLong(position, 0));
        }
        return newBlockBuilder.build();
    }

    private static <T> List<T> listWithNulls(int size) {
        return Stream.generate(() -> null).limit(size).collect(Collectors.toCollection(ArrayList::new));
    }

    private RowRanges getRowRanges(int blockIndex) {
        assert (this.filter != null);
        RowRanges rowRanges = this.blockRowRanges.get(blockIndex);
        if (rowRanges == null) {
            rowRanges = ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)this.filter), (ColumnIndexStore)this.blockIndexStores.get(blockIndex), this.paths.keySet(), (long)this.blocks.get(blockIndex).getRowCount());
            this.blockRowRanges.set(blockIndex, rowRanges);
        }
        return rowRanges;
    }

    private List<ColumnIndexFilterUtils.OffsetRange> concatRanges(List<ColumnIndexFilterUtils.OffsetRange> offsetRanges) {
        ArrayList<ColumnIndexFilterUtils.OffsetRange> pageRanges = new ArrayList<ColumnIndexFilterUtils.OffsetRange>();
        ColumnIndexFilterUtils.OffsetRange currentParts = null;
        for (ColumnIndexFilterUtils.OffsetRange range : offsetRanges) {
            long startPosition = range.getOffset();
            if (currentParts == null || currentParts.endPos() != startPosition) {
                currentParts = new ColumnIndexFilterUtils.OffsetRange(startPosition, 0);
            }
            pageRanges.add(currentParts);
            currentParts.extendLength(range.getLength());
        }
        return pageRanges;
    }
}

