/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.writer.valuewriter;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.parquet.writer.valuewriter.PrimitiveValueWriter;
import java.util.Objects;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.schema.PrimitiveType;

public class DateValueWriter
extends PrimitiveValueWriter {
    private final ValuesWriter valuesWriter;

    public DateValueWriter(ValuesWriter valuesWriter, PrimitiveType parquetType) {
        super(parquetType, valuesWriter);
        this.valuesWriter = Objects.requireNonNull(valuesWriter, "valuesWriter is null");
    }

    @Override
    public void write(Block block) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) continue;
            int value = (int)DateType.DATE.getLong(block, position);
            this.valuesWriter.writeInteger(value);
            this.getStatistics().updateStats(value);
        }
    }
}

