/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.prometheus;

import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Marker;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.DateTimeEncoding;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.plugin.prometheus.PrometheusClient;
import com.facebook.presto.plugin.prometheus.PrometheusClock;
import com.facebook.presto.plugin.prometheus.PrometheusColumnHandle;
import com.facebook.presto.plugin.prometheus.PrometheusConnectorConfig;
import com.facebook.presto.plugin.prometheus.PrometheusErrorCode;
import com.facebook.presto.plugin.prometheus.PrometheusPredicateTimeInfo;
import com.facebook.presto.plugin.prometheus.PrometheusSplit;
import com.facebook.presto.plugin.prometheus.PrometheusTable;
import com.facebook.presto.plugin.prometheus.PrometheusTableHandle;
import com.facebook.presto.plugin.prometheus.PrometheusTableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.airlift.units.Duration;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;

public class PrometheusSplitManager
implements ConnectorSplitManager {
    static final long OFFSET_MILLIS = 1L;
    private final PrometheusClient prometheusClient;
    private final PrometheusClock prometheusClock;
    private final URI prometheusURI;
    private final Duration maxQueryRangeDuration;
    private final Duration queryChunkSizeDuration;

    @Inject
    public PrometheusSplitManager(PrometheusClient prometheusClient, PrometheusClock prometheusClock, PrometheusConnectorConfig config) {
        this.prometheusClient = Objects.requireNonNull(prometheusClient, "client is null");
        this.prometheusClock = Objects.requireNonNull(prometheusClock, "prometheusClock is null");
        Objects.requireNonNull(config, "config is null");
        this.prometheusURI = config.getPrometheusURI();
        this.maxQueryRangeDuration = config.getMaxQueryRangeDuration();
        this.queryChunkSizeDuration = config.getQueryChunkSizeDuration();
    }

    protected static List<String> generateTimesForSplits(Instant defaultUpperBound, Duration maxQueryRangeDurationRequested, Duration queryChunkSizeDurationRequested, PrometheusTableHandle tableHandle) {
        Optional<PrometheusPredicateTimeInfo> predicateRange = tableHandle.getPredicate().flatMap(PrometheusSplitManager::determinePredicateTimes);
        EffectiveLimits effectiveLimits = new EffectiveLimits(defaultUpperBound, maxQueryRangeDurationRequested, predicateRange);
        Instant upperBound = effectiveLimits.getUpperBound();
        java.time.Duration maxQueryRangeDuration = effectiveLimits.getMaxQueryRangeDuration();
        java.time.Duration queryChunkSizeDuration = java.time.Duration.ofMillis(queryChunkSizeDurationRequested.toMillis());
        Preconditions.checkState((!maxQueryRangeDuration.isNegative() ? 1 : 0) != 0, (Object)"prometheus.max-query-duration may not be negative");
        Preconditions.checkState((!queryChunkSizeDuration.isNegative() ? 1 : 0) != 0, (Object)"prometheus.query-chunk-duration may not be negative");
        Preconditions.checkState((!queryChunkSizeDuration.isZero() ? 1 : 0) != 0, (Object)"prometheus.query-chunk-duration may not be zero");
        BigDecimal maxQueryRangeDecimal = BigDecimal.valueOf(maxQueryRangeDuration.getSeconds()).add(BigDecimal.valueOf(maxQueryRangeDuration.getNano(), 9));
        BigDecimal queryChunkSizeDecimal = BigDecimal.valueOf(queryChunkSizeDuration.getSeconds()).add(BigDecimal.valueOf(queryChunkSizeDuration.getNano(), 9));
        int numChunks = maxQueryRangeDecimal.divide(queryChunkSizeDecimal, 0, RoundingMode.UP).intValue();
        return Lists.reverse(IntStream.range(0, numChunks).mapToObj(n -> {
            long endTime = upperBound.toEpochMilli() - (long)n * queryChunkSizeDuration.toMillis() - (long)n * 1L;
            return endTime;
        }).map(PrometheusSplitManager::decimalSecondString).collect(Collectors.toList()));
    }

    protected static Optional<PrometheusPredicateTimeInfo> determinePredicateTimes(TupleDomain<ColumnHandle> predicate) {
        Optional maybeColumnHandleDomainMap = predicate.getDomains();
        Optional<Set> maybeKeySet = maybeColumnHandleDomainMap.map(Map::keySet);
        Optional<Set> maybeOnlyPromColHandles = maybeKeySet.map(keySet -> keySet.stream().filter(PrometheusColumnHandle.class::isInstance).collect(Collectors.toSet()));
        Optional<Set> maybeOnlyTimeStampColumnHandles = maybeOnlyPromColHandles.map(handles -> handles.stream().map(PrometheusColumnHandle.class::cast).filter(handle -> handle.getColumnType().equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)).filter(handle -> handle.getColumnName().equals("timestamp")).collect(Collectors.toSet()));
        Map columnHandleDomainMap = (Map)maybeColumnHandleDomainMap.orElse(ImmutableMap.of());
        Optional<Set<Domain>> maybeTimeDomains = maybeOnlyTimeStampColumnHandles.map(columnHandles -> columnHandles.stream().map(columnHandleDomainMap::get).collect(Collectors.toSet()));
        return PrometheusSplitManager.processTimeDomains(maybeTimeDomains);
    }

    private static Optional<PrometheusPredicateTimeInfo> processTimeDomains(Optional<Set<Domain>> maybeTimeDomains) {
        return maybeTimeDomains.map(timeDomains -> {
            PrometheusPredicateTimeInfo.Builder timeInfoBuilder = PrometheusPredicateTimeInfo.builder();
            timeDomains.forEach(domain -> {
                Instant instant;
                long packedValue;
                if (!domain.getValues().getRanges().getSpan().includes(Marker.lowerUnbounded((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE))) {
                    packedValue = (Long)domain.getValues().getRanges().getSpan().getLow().getValue();
                    instant = Instant.ofEpochMilli(DateTimeEncoding.unpackMillisUtc((long)packedValue));
                    timeInfoBuilder.setPredicateLowerTimeBound(Optional.of(instant));
                }
                if (!domain.getValues().getRanges().getSpan().includes(Marker.upperUnbounded((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE))) {
                    packedValue = (Long)domain.getValues().getRanges().getSpan().getHigh().getValue();
                    instant = Instant.ofEpochMilli(DateTimeEncoding.unpackMillisUtc((long)packedValue));
                    timeInfoBuilder.setPredicateUpperTimeBound(Optional.of(instant));
                }
            });
            return timeInfoBuilder.build();
        });
    }

    static String decimalSecondString(long millis) {
        return new BigDecimal(Long.toString(millis)).divide(new BigDecimal(1000L)).toPlainString();
    }

    private static URI buildQuery(URI baseURI, String time, String metricName, Duration queryChunkSizeDuration) throws URISyntaxException {
        return HttpUriBuilder.uriBuilderFrom((URI)baseURI).replacePath("api/v1/query").addParameter("query", new String[]{metricName + "[" + queryChunkSizeDuration.roundTo(queryChunkSizeDuration.getUnit()) + Duration.timeUnitToString((TimeUnit)queryChunkSizeDuration.getUnit()) + "]"}).addParameter("time", new String[]{time}).build();
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingContext splitSchedulingContext) {
        PrometheusTableLayoutHandle layoutHandle = (PrometheusTableLayoutHandle)layout;
        PrometheusTableHandle tableHandle = layoutHandle.getTableHandle();
        PrometheusTable table = this.prometheusClient.getTable(tableHandle.getSchemaName(), tableHandle.getTableName());
        if (table == null) {
            throw new TableNotFoundException(tableHandle.toSchemaTableName());
        }
        List splits = PrometheusSplitManager.generateTimesForSplits(this.prometheusClock.now(), this.maxQueryRangeDuration, this.queryChunkSizeDuration, tableHandle).stream().map(time -> {
            try {
                return new PrometheusSplit(PrometheusSplitManager.buildQuery(this.prometheusURI, time, table.getName(), this.queryChunkSizeDuration));
            }
            catch (URISyntaxException e) {
                throw new PrestoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_UNKNOWN_ERROR, "split URI invalid: " + e.getMessage());
            }
        }).collect(Collectors.toList());
        return new FixedSplitSource(splits);
    }

    private static class EffectiveLimits {
        private final Instant upperBound;
        private final java.time.Duration maxQueryRangeDuration;

        public EffectiveLimits(Instant defaultUpperBound, Duration maxQueryRangeDurationRequested, Optional<PrometheusPredicateTimeInfo> maybePredicateRange) {
            if (maybePredicateRange.isPresent()) {
                this.upperBound = maybePredicateRange.get().getPredicateUpperTimeBound().isPresent() ? maybePredicateRange.get().getPredicateUpperTimeBound().get() : defaultUpperBound;
                this.maxQueryRangeDuration = maybePredicateRange.get().getPredicateLowerTimeBound().isPresent() ? java.time.Duration.between(maybePredicateRange.get().getPredicateLowerTimeBound().get(), this.upperBound) : java.time.Duration.ofMillis(maxQueryRangeDurationRequested.toMillis());
            } else {
                this.upperBound = defaultUpperBound;
                this.maxQueryRangeDuration = java.time.Duration.ofMillis(maxQueryRangeDurationRequested.toMillis());
            }
        }

        public Instant getUpperBound() {
            return this.upperBound;
        }

        public java.time.Duration getMaxQueryRangeDuration() {
            return this.maxQueryRangeDuration;
        }
    }
}

