/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetastoreTaskThread;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;

public class AcidCompactionHistoryService
implements MetastoreTaskThread {
    private static final Logger LOG = LoggerFactory.getLogger(AcidCompactionHistoryService.class);
    private Configuration conf;
    private TxnStore txnHandler;

    public void setConf(Configuration configuration) {
        this.conf = configuration;
        this.txnHandler = TxnUtils.getTxnStore(this.conf);
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public long runFrequency(TimeUnit unit) {
        return MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.COMPACTOR_HISTORY_REAPER_INTERVAL, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TxnStore.MutexAPI.LockHandle handle = null;
        try {
            handle = this.txnHandler.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.CompactionHistory.name());
            long startTime = System.currentTimeMillis();
            this.txnHandler.purgeCompactionHistory();
            LOG.debug("History reaper reaper ran for " + (System.currentTimeMillis() - startTime) / 1000L + "seconds.");
        }
        catch (Throwable t) {
            LOG.error("Serious error in {}", Thread.currentThread().getName(), ": {}" + t.getMessage(), t);
        }
        finally {
            if (handle != null) {
                handle.releaseLocks();
            }
        }
    }
}

