/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.facebook.presto.hive.;
import com.facebook.presto.hive.$internal.com.google.common.base.Preconditions;
import com.facebook.presto.hive.$internal.org.json.JSONException;
import com.facebook.presto.hive.$internal.org.json.JSONObject;
import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;

public class YarnQueueHelper {
    private static final Logger LOG = LoggerFactory.getLogger(YarnQueueHelper.class);
    private static final String PERMISSION_PATH = "/ws/v1/cluster/queues/%s/access?user=%s";
    private final String[] rmNodes;
    private int lastKnownGoodUrl;

    public YarnQueueHelper(HiveConf conf) {
        this.rmNodes = conf.getTrimmedStrings("yarn.resourcemanager.webapp.address");
        Preconditions.checkArgument(this.rmNodes != null && this.rmNodes.length > 0, "yarn.resourcemanager.webapp.address must be set to enable queue access checks");
        this.lastKnownGoodUrl = 0;
    }

    public void checkQueueAccess(String queueName, String userName) throws IOException, HiveException {
        String urlSuffix = String.format(PERMISSION_PATH, queueName, userName);
        int urlIx = this.lastKnownGoodUrl;
        int lastUrlIx = (urlIx == 0 ? this.rmNodes.length : urlIx) - 1;
        Exception firstError = null;
        while (true) {
            boolean isCallOk;
            String error;
            block6: {
                String node = this.rmNodes[urlIx];
                error = null;
                isCallOk = false;
                try {
                    error = this.checkQueueAccessFromSingleRm("http://" + node + urlSuffix);
                    isCallOk = true;
                }
                catch (Exception ex) {
                    LOG.warn("Cannot check queue access against RM " + node, ex);
                    if (firstError != null) break block6;
                    firstError = ex;
                }
            }
            if (isCallOk) {
                this.lastKnownGoodUrl = urlIx;
                if (error == null) {
                    return;
                }
                throw new HiveException(error.isEmpty() ? userName + " has no access to " + queueName : error);
            }
            if (urlIx == lastUrlIx) {
                throw new IOException("Cannot access any RM service; first error", firstError);
            }
            urlIx = (urlIx + 1) % this.rmNodes.length;
        }
    }

    private String checkQueueAccessFromSingleRm(String urlString) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection connection = UserGroupInformation.isSecurityEnabled() ? this.getSecureConnection(url) : (HttpURLConnection)url.openConnection();
        int statusCode = connection.getResponseCode();
        switch (statusCode) {
            case 200: {
                return this.processResponse(connection);
            }
            case 403: {
                throw new IOException(this.handleUnexpectedStatusCode(connection, statusCode, "check that the HiveServer2 principal is in the administrator list of the root YARN queue"));
            }
        }
        throw new IOException(this.handleUnexpectedStatusCode(connection, statusCode, null));
    }

    private String processResponse(HttpURLConnection connection) throws IOException {
        InputStream stream = connection.getInputStream();
        if (stream == null) {
            throw new IOException(this.handleUnexpectedStatusCode(connection, 200, "No input on successful API call"));
        }
        String jsonStr = .IOUtils.toString((InputStream)stream);
        try {
            JSONObject obj = new JSONObject(jsonStr);
            boolean result = obj.getBoolean("allowed");
            if (result) {
                return null;
            }
            String diag = obj.getString("diagnostics");
            return diag == null ? "" : diag;
        }
        catch (JSONException ex) {
            LOG.error("Couldn't parse " + jsonStr, ex);
            throw ex;
        }
    }

    private HttpURLConnection getSecureConnection(URL url) throws IOException {
        AuthenticatedURL.Token token = new AuthenticatedURL.Token();
        try {
            return new AuthenticatedURL().openConnection(url, token);
        }
        catch (AuthenticationException e) {
            throw new IOException(e);
        }
    }

    public String handleUnexpectedStatusCode(HttpURLConnection connection, int statusCode, String errorStr) throws IOException {
        InputStream errorStream = connection.getErrorStream();
        String error = "Received " + statusCode + (errorStr == null ? "" : " (" + errorStr + ")");
        if (errorStream != null) {
            error = error + ": " + .IOUtils.toString((InputStream)errorStream);
        } else {
            errorStream = connection.getInputStream();
            if (errorStream != null) {
                error = error + ": " + .IOUtils.toString((InputStream)errorStream);
            }
        }
        return error;
    }
}

