/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.keyseries;

import com.facebook.presto.hive.$internal.com.google.common.base.Preconditions;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.vector.keyseries.VectorKeySeries;
import org.apache.hadoop.hive.ql.exec.vector.keyseries.VectorKeySeriesImpl;

public abstract class VectorKeySeriesSingleImpl
extends VectorKeySeriesImpl
implements VectorKeySeries {
    private static final Log LOG = LogFactory.getLog(VectorKeySeriesSingleImpl.class.getName());
    protected int currentBatchSize;
    protected int seriesCount = 0;
    protected int seriesPosition = 0;
    protected final int[] duplicateCounts = new int[1024];
    protected final boolean[] seriesIsAllNull = new boolean[1024];
    protected int nonNullKeyCount = 0;
    protected int nonNullKeyPosition = -1;
    protected final int[] hashCodes = new int[1024];

    VectorKeySeriesSingleImpl() {
    }

    public boolean validate() {
        Preconditions.checkState(this.seriesCount > 0);
        Preconditions.checkState(this.seriesCount <= this.currentBatchSize);
        Preconditions.checkState(this.nonNullKeyCount >= 0);
        Preconditions.checkState(this.nonNullKeyCount <= this.seriesCount);
        this.validateDuplicateCount();
        return true;
    }

    private void validateDuplicateCount() {
        int sum = 0;
        for (int i = 0; i < this.seriesCount; ++i) {
            int duplicateCount = this.duplicateCounts[i];
            Preconditions.checkState(duplicateCount > 0);
            Preconditions.checkState(duplicateCount <= this.currentBatchSize);
            sum += duplicateCount;
        }
        Preconditions.checkState(sum == this.currentBatchSize);
    }

    @Override
    public void positionToFirst() {
        this.seriesPosition = 0;
        this.currentLogical = 0;
        this.currentDuplicateCount = this.duplicateCounts[0];
        this.currentIsAllNull = this.seriesIsAllNull[0];
        if (!this.currentIsAllNull) {
            this.nonNullKeyPosition = 0;
            this.currentHashCode = this.hashCodes[0];
            this.setNextNonNullKey(0);
        } else {
            this.nonNullKeyPosition = -1;
        }
        Preconditions.checkState(this.currentDuplicateCount > 0);
    }

    @Override
    public boolean next() {
        this.currentLogical += this.currentDuplicateCount;
        if (this.currentLogical >= this.currentBatchSize) {
            return false;
        }
        Preconditions.checkState(this.seriesPosition + 1 < this.seriesCount);
        ++this.seriesPosition;
        this.currentDuplicateCount = this.duplicateCounts[this.seriesPosition];
        this.currentIsAllNull = this.seriesIsAllNull[this.seriesPosition];
        if (!this.currentIsAllNull) {
            Preconditions.checkState(this.nonNullKeyPosition + 1 < this.nonNullKeyCount);
            ++this.nonNullKeyPosition;
            this.currentHashCode = this.hashCodes[this.nonNullKeyPosition];
            this.setNextNonNullKey(this.nonNullKeyPosition);
        }
        Preconditions.checkState(this.currentDuplicateCount > 0);
        return true;
    }

    public void advance(int duplicateCount) {
        this.currentLogical += this.currentDuplicateCount;
        this.currentDuplicateCount -= duplicateCount;
        if (this.currentDuplicateCount == 0) {
            ++this.seriesPosition;
            this.currentIsAllNull = this.seriesIsAllNull[this.seriesPosition];
            this.currentDuplicateCount = this.duplicateCounts[this.seriesPosition];
            if (!this.currentIsAllNull) {
                ++this.nonNullKeyPosition;
                this.currentHashCode = this.hashCodes[this.nonNullKeyPosition];
                this.setNextNonNullKey(this.nonNullKeyPosition);
            }
        }
    }

    protected abstract void setNextNonNullKey(int var1);
}

