/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import com.facebook.presto.hive.;
import com.facebook.presto.hive.$internal.com.google.common.base.Joiner;
import com.facebook.presto.hive.$internal.com.google.common.collect.Lists;
import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.VariableSubstitution;
import org.apache.hadoop.hive.llap.registry.LlapServiceInstance;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.processors.CommandUtil;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.session.SessionState;

public class LlapClusterResourceProcessor
implements CommandProcessor {
    public static final Logger LOG = LoggerFactory.getLogger(LlapClusterResourceProcessor.class);
    private .Options CLUSTER_OPTIONS = new .Options();
    private .HelpFormatter helpFormatter = new .HelpFormatter();

    LlapClusterResourceProcessor() {
        this.CLUSTER_OPTIONS.addOption("info", "info", false, "Information about LLAP cluster");
    }

    private CommandProcessorResponse returnErrorResponse(String errmsg) {
        return new CommandProcessorResponse(1, "LLAP Cluster Processor Helper Failed:" + errmsg, null);
    }

    @Override
    public CommandProcessorResponse run(String command) {
        SessionState ss = SessionState.get();
        command = new VariableSubstitution(() -> SessionState.get().getHiveVariables()).substitute(ss.getConf(), command);
        String[] tokens = command.split("\\s+");
        if (tokens.length < 1) {
            return this.returnErrorResponse("Command arguments are empty.");
        }
        String[] params = Arrays.copyOfRange(tokens, 1, tokens.length);
        try {
            return this.llapClusterCommandHandler(ss, params);
        }
        catch (Exception e) {
            return this.returnErrorResponse(e.getMessage());
        }
    }

    private CommandProcessorResponse llapClusterCommandHandler(SessionState ss, String[] params) throws .ParseException {
        boolean hasInfo;
        .CommandLine args = this.parseCommandArgs(this.CLUSTER_OPTIONS, params);
        String hs2Host = null;
        if (ss.isHiveServerQuery()) {
            hs2Host = ss.getHiveServer2Host();
        }
        if (hasInfo = args.hasOption("info")) {
            ArrayList<String> fullCommand = Lists.newArrayList("llap", "cluster");
            fullCommand.addAll(Arrays.asList(params));
            CommandProcessorResponse authErrResp = CommandUtil.authorizeCommandAndServiceObject(ss, HiveOperationType.LLAP_CLUSTER_INFO, fullCommand, hs2Host);
            if (authErrResp != null) {
                return authErrResp;
            }
            try {
                LlapRegistryService llapRegistryService = LlapRegistryService.getClient((Configuration)ss.getConf());
                String appId = llapRegistryService.getApplicationId() == null ? "null" : llapRegistryService.getApplicationId().toString();
                for (LlapServiceInstance instance : llapRegistryService.getInstances().getAll()) {
                    ss.out.println(Joiner.on("\t").join(appId, instance.getWorkerIdentity(), instance.getHost(), instance.getRpcPort(), (long)instance.getResource().getMemory() * 1024L * 1024L, instance.getResource().getVirtualCores()));
                }
                return this.createProcessorSuccessResponse();
            }
            catch (Exception e) {
                LOG.error("Unable to list LLAP instances. err: ", e);
                return this.returnErrorResponse("Unable to list LLAP instances. err: " + e.getMessage());
            }
        }
        String usage = this.getUsageAsString();
        return this.returnErrorResponse("Unsupported sub-command option. " + usage);
    }

    private CommandProcessorResponse createProcessorSuccessResponse() {
        return new CommandProcessorResponse(0, null, null, this.getSchema());
    }

    private Schema getSchema() {
        Schema sch = new Schema();
        sch.addToFieldSchemas(new FieldSchema("applicationId", "string", ""));
        sch.addToFieldSchemas(new FieldSchema("workerIdentity", "string", ""));
        sch.addToFieldSchemas(new FieldSchema("hostname", "string", ""));
        sch.addToFieldSchemas(new FieldSchema("rpcPort", "string", ""));
        sch.addToFieldSchemas(new FieldSchema("memory", "string", ""));
        sch.addToFieldSchemas(new FieldSchema("vcores", "string", ""));
        sch.putToProperties("serialization.null.format", "\\N");
        return sch;
    }

    private String getUsageAsString() {
        StringWriter out = new StringWriter();
        PrintWriter pw = new PrintWriter(out);
        this.helpFormatter.printUsage(pw, this.helpFormatter.getWidth(), "llap cluster", this.CLUSTER_OPTIONS);
        pw.flush();
        return out.toString();
    }

    private .CommandLine parseCommandArgs(.Options opts, String[] args) throws .ParseException {
        .GnuParser parser = new .GnuParser();
        return parser.parse(opts, args);
    }

    @Override
    public void close() {
    }
}

