/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveMetastoreClientFactoryImpl;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePolicyProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveResourceACLs;

public class PrivilegeSynchonizer
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(PrivilegeSynchonizer.class);
    public static final String GRANTOR = "ranger";
    private IMetaStoreClient hiveClient;
    private LeaderLatch privilegeSynchonizerLatch;
    private HiveConf hiveConf;
    private HiveAuthorizer authorizer;

    public PrivilegeSynchonizer(LeaderLatch privilegeSynchonizerLatch, HiveAuthorizer authorizer, HiveConf hiveConf) {
        try {
            this.hiveClient = new HiveMetastoreClientFactoryImpl().getHiveMetastoreClient();
        }
        catch (HiveAuthzPluginException e) {
            throw new RuntimeException("Error creating getHiveMetastoreClient", e);
        }
        this.privilegeSynchonizerLatch = privilegeSynchonizerLatch;
        this.authorizer = authorizer;
        this.hiveConf = hiveConf;
    }

    private void addACLsToBag(Map<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>> principalAclsMap, PrivilegeBag privBag, HiveObjectType objectType, String dbName, String tblName, String columnName, PrincipalType principalType) {
        for (Map.Entry<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>> principalAcls : principalAclsMap.entrySet()) {
            String principal = principalAcls.getKey();
            block6: for (Map.Entry<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult> acl : principalAcls.getValue().entrySet()) {
                if (acl.getValue() != HiveResourceACLs.AccessResult.ALLOWED) continue;
                switch (objectType) {
                    case DATABASE: {
                        privBag.addToPrivileges(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.DATABASE, dbName, null, null, null), principal, principalType, new PrivilegeGrantInfo(acl.getKey().toString(), (int)(System.currentTimeMillis() / 1000L), GRANTOR, PrincipalType.USER, false)));
                        continue block6;
                    }
                    case TABLE: {
                        privBag.addToPrivileges(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.TABLE, dbName, tblName, null, null), principal, principalType, new PrivilegeGrantInfo(acl.getKey().toString(), (int)(System.currentTimeMillis() / 1000L), GRANTOR, PrincipalType.USER, false)));
                        continue block6;
                    }
                    case COLUMN: {
                        privBag.addToPrivileges(new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.COLUMN, dbName, tblName, null, columnName), principal, principalType, new PrivilegeGrantInfo(acl.getKey().toString(), (int)(System.currentTimeMillis() / 1000L), GRANTOR, PrincipalType.USER, false)));
                        continue block6;
                    }
                }
                throw new RuntimeException("Get unknown object type " + (Object)((Object)objectType));
            }
        }
    }

    private HiveObjectRef getObjToRefresh(HiveObjectType type, String dbName, String tblName) throws Exception {
        HiveObjectRef objToRefresh = null;
        switch (type) {
            case DATABASE: {
                objToRefresh = new HiveObjectRef(HiveObjectType.DATABASE, dbName, null, null, null);
                break;
            }
            case TABLE: {
                objToRefresh = new HiveObjectRef(HiveObjectType.TABLE, dbName, tblName, null, null);
                break;
            }
            case COLUMN: {
                objToRefresh = new HiveObjectRef(HiveObjectType.COLUMN, dbName, tblName, null, null);
                break;
            }
            default: {
                throw new RuntimeException("Get unknown object type " + (Object)((Object)type));
            }
        }
        return objToRefresh;
    }

    private void addGrantPrivilegesToBag(HivePolicyProvider policyProvider, PrivilegeBag privBag, HiveObjectType type, String dbName, String tblName, String columnName) throws Exception {
        HiveResourceACLs objectAcls = null;
        switch (type) {
            case DATABASE: {
                objectAcls = policyProvider.getResourceACLs(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.DATABASE, dbName, null));
                break;
            }
            case TABLE: {
                objectAcls = policyProvider.getResourceACLs(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW, dbName, tblName));
                break;
            }
            case COLUMN: {
                objectAcls = policyProvider.getResourceACLs(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.COLUMN, dbName, tblName, null, columnName));
                break;
            }
            default: {
                throw new RuntimeException("Get unknown object type " + (Object)((Object)type));
            }
        }
        if (objectAcls == null) {
            return;
        }
        this.addACLsToBag(objectAcls.getUserPermissions(), privBag, type, dbName, tblName, columnName, PrincipalType.USER);
        this.addACLsToBag(objectAcls.getGroupPermissions(), privBag, type, dbName, tblName, columnName, PrincipalType.GROUP);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    HivePolicyProvider policyProvider = this.authorizer.getHivePolicyProvider();
                    long interval = HiveConf.getTimeVar(this.hiveConf, HiveConf.ConfVars.HIVE_PRIVILEGE_SYNCHRONIZER_INTERVAL, TimeUnit.SECONDS);
                    if (this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_PRIVILEGE_SYNCHRONIZER)) {
                        if (!this.privilegeSynchonizerLatch.await(interval, TimeUnit.SECONDS)) continue;
                        LOG.debug("Start synchonize privilege");
                        for (String dbName : this.hiveClient.getAllDatabases()) {
                            HiveObjectRef dbToRefresh = this.getObjToRefresh(HiveObjectType.DATABASE, dbName, null);
                            PrivilegeBag grantDatabaseBag = new PrivilegeBag();
                            this.addGrantPrivilegesToBag(policyProvider, grantDatabaseBag, HiveObjectType.DATABASE, dbName, null, null);
                            this.hiveClient.refresh_privileges(dbToRefresh, grantDatabaseBag);
                            for (String tblName : this.hiveClient.getAllTables(dbName)) {
                                HiveObjectRef tableToRefresh = this.getObjToRefresh(HiveObjectType.TABLE, dbName, tblName);
                                PrivilegeBag grantTableBag = new PrivilegeBag();
                                this.addGrantPrivilegesToBag(policyProvider, grantTableBag, HiveObjectType.TABLE, dbName, tblName, null);
                                this.hiveClient.refresh_privileges(tableToRefresh, grantTableBag);
                                HiveObjectRef tableOfColumnsToRefresh = this.getObjToRefresh(HiveObjectType.COLUMN, dbName, tblName);
                                PrivilegeBag grantColumnBag = new PrivilegeBag();
                                Table tbl = this.hiveClient.getTable(dbName, tblName);
                                for (FieldSchema fs : tbl.getPartitionKeys()) {
                                    this.addGrantPrivilegesToBag(policyProvider, grantColumnBag, HiveObjectType.COLUMN, dbName, tblName, fs.getName());
                                }
                                for (FieldSchema fs : tbl.getSd().getCols()) {
                                    this.addGrantPrivilegesToBag(policyProvider, grantColumnBag, HiveObjectType.COLUMN, dbName, tblName, fs.getName());
                                }
                                this.hiveClient.refresh_privileges(tableOfColumnsToRefresh, grantColumnBag);
                            }
                        }
                    }
                    Thread.sleep(interval * 1000L);
                    LOG.debug("Success synchonize privilege");
                }
            }
            catch (Exception e) {
                LOG.error("Error initializing PrivilegeSynchonizer: " + e.getMessage(), e);
                continue;
            }
            break;
        }
    }
}

