/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import com.facebook.presto.hive.$internal.com.google.common.base.Preconditions;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.IllegalInstantException;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadWritableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;

public class TimestampParser {
    protected static final String[] stringArray = new String[0];
    protected static final String millisFormatString = "millis";
    @Nullable
    private static final DateTime startingDateValue = TimestampParser.makeStartingDateValue();
    protected String[] formatStrings = null;
    protected DateTimeFormatter fmt = null;

    @Nullable
    private static DateTime makeStartingDateValue() {
        try {
            return new DateTime(1970, 1, 1, 0, 0, 0, 0);
        }
        catch (IllegalInstantException e) {
            return null;
        }
    }

    public TimestampParser() {
    }

    public TimestampParser(TimestampParser tsParser) {
        this(tsParser.formatStrings == null ? null : Arrays.copyOf(tsParser.formatStrings, tsParser.formatStrings.length));
    }

    public TimestampParser(List<String> formatStrings) {
        this(formatStrings == null ? null : formatStrings.toArray(stringArray));
    }

    public TimestampParser(String[] formatStrings) {
        this.formatStrings = formatStrings;
        if (formatStrings != null && formatStrings.length > 0) {
            DateTimeParser[] parsers = new DateTimeParser[formatStrings.length];
            for (int idx = 0; idx < formatStrings.length; ++idx) {
                String formatString = formatStrings[idx];
                parsers[idx] = formatString.equalsIgnoreCase(millisFormatString) ? new MillisDateFormatParser() : DateTimeFormat.forPattern((String)formatString).getParser();
            }
            this.fmt = new DateTimeFormatterBuilder().append(null, parsers).toFormatter().withDefaultYear(1970);
        }
    }

    public Timestamp parseTimestamp(String strValue) throws IllegalArgumentException {
        Optional<Timestamp> parsed;
        if (this.fmt != null && (parsed = this.tryParseWithFormat(strValue)).isPresent()) {
            return parsed.get();
        }
        return Timestamp.valueOf(strValue);
    }

    private Optional<Timestamp> tryParseWithFormat(String strValue) {
        Preconditions.checkState(this.fmt != null);
        if (startingDateValue != null) {
            MutableDateTime mdt = new MutableDateTime((Object)startingDateValue);
            int ret = this.fmt.parseInto((ReadWritableInstant)mdt, strValue, 0);
            if (ret == strValue.length()) {
                return Optional.of(new Timestamp(mdt.getMillis()));
            }
            return Optional.empty();
        }
        try {
            DateTime dt = this.fmt.parseDateTime(strValue);
            return Optional.of(new Timestamp(dt.getMillis()));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public static class MillisDateFormatParser
    implements DateTimeParser {
        private static final ThreadLocal<Matcher> numericMatcher = new ThreadLocal<Matcher>(){

            @Override
            protected Matcher initialValue() {
                return Pattern.compile("(-?\\d+)(\\.\\d+)?$").matcher("");
            }
        };
        private static final DateTimeFieldType[] dateTimeFields = new DateTimeFieldType[]{DateTimeFieldType.year(), DateTimeFieldType.monthOfYear(), DateTimeFieldType.dayOfMonth(), DateTimeFieldType.hourOfDay(), DateTimeFieldType.minuteOfHour(), DateTimeFieldType.secondOfMinute(), DateTimeFieldType.millisOfSecond()};

        public int estimateParsedLength() {
            return 13;
        }

        public int parseInto(DateTimeParserBucket bucket, String text, int position) {
            String substr = text.substring(position);
            Matcher matcher = numericMatcher.get();
            matcher.reset(substr);
            if (!matcher.matches()) {
                return -1;
            }
            long millis = Long.parseLong(matcher.group(1));
            DateTime dt = new DateTime(millis);
            for (DateTimeFieldType field : dateTimeFields) {
                bucket.saveField(field, dt.get(field));
            }
            return substr.length();
        }
    }
}

