/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport;

import com.facebook.drift.codec.ThriftCodec;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public final class ParameterMetadata {
    private final short fieldId;
    private final String name;
    private final ThriftCodec<Object> codec;

    public ParameterMetadata(short fieldId, String name, ThriftCodec<Object> codec) {
        Preconditions.checkArgument((fieldId >= 0 ? 1 : 0) != 0, (Object)"fieldId is negative");
        this.fieldId = fieldId;
        this.name = Objects.requireNonNull(name, "name is null");
        this.codec = Objects.requireNonNull(codec, "codec is null");
    }

    public short getFieldId() {
        return this.fieldId;
    }

    public String getName() {
        return this.name;
    }

    public ThriftCodec<Object> getCodec() {
        return this.codec;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fieldId", (int)this.fieldId).add("name", (Object)this.name).toString();
    }
}

